/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.services;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.QName;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;

@Operation(id="Directory.Entries", category="Services", label="Get directory entries", description="Get the entries of a directory. This is returning a blob containing a serialized JSON array. The input document, if specified, is used as a context for a potential local configuration of the directory.", addToStudio=false)
public class GetDirectoryEntries {
    public static final String ID = "Directory.Entries";
    @Context
    protected OperationContext ctx;
    @Context
    protected DirectoryService directoryService;
    @Context
    protected SchemaManager schemaManager;
    @Param(name="directoryName", required=true)
    protected String directoryName;
    @Param(name="translateLabels", required=false)
    protected boolean translateLabels;
    @Param(name="lang", required=false)
    protected String lang;

    @OperationMethod
    public Blob run(DocumentModel doc) throws IOException {
        Directory directory = this.directoryService.getDirectory(this.directoryName, doc);
        try (Session session = directory.getSession();){
            DocumentModelList entries = session.getEntries();
            String schemaName = directory.getSchema();
            Schema schema = this.schemaManager.getSchema(schemaName);
            ArrayList rows = new ArrayList();
            for (DocumentModel entry : entries) {
                LinkedHashMap<String, Serializable> obj = new LinkedHashMap<String, Serializable>();
                for (Field field : schema.getFields()) {
                    QName fieldName = field.getName();
                    String key = fieldName.getLocalName();
                    Object value = entry.getPropertyValue(fieldName.getPrefixedName());
                    if (this.translateLabels && "label".equals(key)) {
                        value = this.translate((String)value);
                    }
                    obj.put(key, (Serializable)value);
                }
                rows.add(obj);
            }
            Iterator iterator = Blobs.createJSONBlobFromValue(rows);
            return iterator;
        }
    }

    @OperationMethod
    public Blob run() throws IOException {
        return this.run(null);
    }

    protected Locale getLocale() {
        if (this.lang == null) {
            this.lang = (String)this.ctx.get((Object)"lang");
        }
        if (this.lang == null) {
            this.lang = "en";
        }
        return new Locale(this.lang);
    }

    protected String translate(String key) {
        if (key == null) {
            return "";
        }
        return I18NUtils.getMessageString((String)"messages", (String)key, (Object[])new Object[0], (Locale)this.getLocale());
    }
}

