/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.services.directory;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;

@Operation(id="Directory.CreateVocabularyEntry", category="Services", label="Vocabulary: Add Entry", description="Add a new entry in the <i>vocabularyName</i> vocabulary only if <i>id</i> is not found (an existing entry isnot updated). If <i>label</i> is empty, it is set to the id. WARNING: Current user must have enough rights to write in a vocabulary.")
public class CreateVocabularyEntry {
    public static final String ID = "Directory.CreateVocabularyEntry";
    @Context
    protected DirectoryService directoryService;
    @Context
    protected SchemaManager schemaManager;
    @Param(name="vocabularyName")
    protected String name;
    @Param(name="id")
    protected String id;
    @Param(name="label", required=false)
    protected String label;
    @Param(name="parent", required=false)
    protected String parent = "";
    @Param(name="obsolete", required=false)
    protected long obsolete;
    @Param(name="ordering", required=false)
    protected long ordering;

    @OperationMethod
    public void run() {
        if (StringUtils.isBlank((CharSequence)this.id)) {
            return;
        }
        try (Session directorySession = this.directoryService.open(this.name);){
            if (directorySession.hasEntry(this.id)) {
                return;
            }
            HashMap<String, Object> entry = new HashMap<String, Object>();
            entry.put("id", this.id);
            entry.put("label", StringUtils.defaultIfEmpty((CharSequence)this.label, (CharSequence)this.id));
            String dirSchema = this.directoryService.getDirectorySchema(this.name);
            Schema schema = this.schemaManager.getSchema(dirSchema);
            if (schema.hasField("parent")) {
                entry.put("parent", this.parent);
            }
            entry.put("obsolete", this.obsolete);
            entry.put("ordering", this.ordering);
            directorySession.createEntry(entry);
        }
    }
}

