/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.users;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.usermanager.UserManager;

@Operation(id="User.CreateOrUpdate", aliases={"Services.CreateUser"}, category="Users & Groups", label="Create or Update User", description="Create or Update User.")
public class CreateOrUpdateUser {
    public static final String ID = "User.CreateOrUpdate";
    public static final String CREATE_OR_UPDATE = "createOrUpdate";
    public static final String CREATE = "create";
    public static final String UPDATE = "update";
    protected static final String USER_COLON = "user:";
    @Context
    protected UserManager userManager;
    @Param(name="username")
    protected String username;
    @Param(name="password", required=false)
    protected String password;
    @Param(name="email", required=false)
    protected String email;
    @Param(name="firstName", required=false)
    protected String firstName;
    @Param(name="lastName", required=false)
    protected String lastName;
    @Param(name="company", required=false)
    protected String company;
    @Param(name="tenantId", required=false)
    protected String tenantId;
    @Param(name="groups", required=false)
    protected StringList groups;
    @Param(name="properties", required=false)
    protected Properties properties = new Properties();
    @Param(name="mode", required=false, values={"createOrUpdate", "create", "update"})
    protected String mode;

    @OperationMethod
    public void run() throws OperationException {
        String value;
        String key;
        boolean create;
        DocumentModel userDoc = this.userManager.getUserModel(this.username);
        if (userDoc == null) {
            if (UPDATE.equals(this.mode)) {
                throw new OperationException("Cannot update non-existent user: " + this.username);
            }
            create = true;
            userDoc = this.userManager.getBareUserModel();
            userDoc.setProperty("user", "username", (Object)this.username);
        } else {
            if (CREATE.equals(this.mode)) {
                throw new OperationException("Cannot create already-existing user: " + this.username);
            }
            create = false;
        }
        if (this.groups != null) {
            userDoc.setProperty("user", "groups", (Object)this.groups);
        }
        for (Map.Entry entry : Arrays.asList(new AbstractMap.SimpleEntry<String, String>("tenantId", this.tenantId), new AbstractMap.SimpleEntry<String, String>("password", this.password), new AbstractMap.SimpleEntry<String, String>("email", this.email), new AbstractMap.SimpleEntry<String, String>("firstName", this.firstName), new AbstractMap.SimpleEntry<String, String>("lastName", this.lastName), new AbstractMap.SimpleEntry<String, String>("company", this.company))) {
            key = (String)entry.getKey();
            value = (String)entry.getValue();
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            this.properties.put((Object)key, (Object)value);
        }
        for (Map.Entry entry : this.properties.entrySet()) {
            key = (String)entry.getKey();
            value = (String)entry.getValue();
            if (key.startsWith(USER_COLON)) {
                key = key.substring(USER_COLON.length());
            }
            userDoc.setProperty("user", key, (Object)value);
        }
        if (create) {
            userDoc = this.userManager.createUser(userDoc);
        } else {
            this.userManager.updateUser(userDoc);
            userDoc = this.userManager.getUserModel(this.username);
        }
    }
}

