/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.users;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.features.SuggestConstants;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.query.sql.model.MultiExpression;
import org.nuxeo.ecm.core.query.sql.model.Operator;
import org.nuxeo.ecm.core.query.sql.model.OrderByExprs;
import org.nuxeo.ecm.core.query.sql.model.Predicates;
import org.nuxeo.ecm.core.query.sql.model.QueryBuilder;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.QName;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.SizeLimitExceededException;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.usermanager.UserAdapter;
import org.nuxeo.ecm.platform.usermanager.UserManager;

@Operation(id="UserGroup.Suggestion", category="Services", label="Get user/group suggestion", description="Get the user/group list of the running instance. This is returning a blob containing a serialized JSON array..", addToStudio=false)
public class SuggestUserEntries {
    private static final Log log = LogFactory.getLog(SuggestUserEntries.class);
    public static final String ID = "UserGroup.Suggestion";
    public static final String POWERUSERS = "powerusers";
    @Context
    protected OperationContext ctx;
    @Context
    protected SchemaManager schemaManager;
    @Param(name="searchTerm", alias={"prefix"}, required=false)
    protected String prefix;
    @Param(name="searchType", required=false)
    protected String searchType;
    @Param(name="groupRestriction", required=false, description="Enter the id of a group to suggest only user from this group.")
    protected String groupRestriction;
    @Param(name="hideAdminGroups", required=false, description="If set, remove all administrator groups from the suggestions")
    protected boolean hideAdminGroups;
    @Param(name="hidePowerUsersGroup", required=false, description="If set, remove power users group from the suggestions")
    protected boolean hidePowerUsersGroup;
    @Param(name="userSuggestionMaxSearchResults", required=false)
    protected Integer userSuggestionMaxSearchResults;
    @Param(name="firstLabelField", required=false)
    protected String firstLabelField;
    @Param(name="secondLabelField", required=false)
    protected String secondLabelField;
    @Param(name="thirdLabelField", required=false)
    protected String thirdLabelField;
    @Param(name="hideFirstLabel", required=false)
    protected boolean hideFirstLabel = false;
    @Param(name="hideSecondLabel", required=false)
    protected boolean hideSecondLabel = false;
    @Param(name="hideThirdLabel", required=false)
    protected boolean hideThirdLabel;
    @Param(name="displayEmailInSuggestion", required=false)
    protected boolean displayEmailInSuggestion;
    @Param(name="hideIcon", required=false)
    protected boolean hideIcon;
    @Context
    protected UserManager userManager;
    @Context
    protected DirectoryService directoryService;
    @Param(name="lang", required=false)
    protected String lang;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @OperationMethod
    public Blob run() throws IOException {
        List<Object> result = new ArrayList();
        boolean isGroupRestriction = !StringUtils.isBlank((CharSequence)this.groupRestriction);
        boolean groupOnly = false;
        boolean userOnly = isGroupRestriction;
        if (!isGroupRestriction && this.searchType != null && !this.searchType.isEmpty()) {
            if (this.searchType.equals("USER_TYPE")) {
                userOnly = true;
            } else if (this.searchType.equals("GROUP_TYPE")) {
                groupOnly = true;
            }
        }
        int limit = this.userSuggestionMaxSearchResults == null ? 0 : this.userSuggestionMaxSearchResults;
        try {
            int userSize = 0;
            int groupSize = 0;
            if (!groupOnly) {
                if (limit <= 0 || !isGroupRestriction) {
                    DocumentModelList userList = this.searchUsers(limit);
                    result = this.usersToMapWithGroupRestrictions(userList);
                } else {
                    long currentLimit = limit;
                    int prevUserListSize = -1;
                    do {
                        DocumentModelList userList = this.searchUsers(currentLimit);
                        result = this.usersToMapWithGroupRestrictions(userList);
                        int userListSize = userList.size();
                        if (userListSize == prevUserListSize || result.size() > limit) break;
                        prevUserListSize = userListSize;
                    } while ((currentLimit *= 2L) <= Integer.MAX_VALUE);
                }
                userSize = result.size();
            }
            if (!userOnly) {
                Schema schema = this.schemaManager.getSchema(this.userManager.getGroupSchemaName());
                DocumentModelList groupList = this.userManager.searchGroups(this.prefix);
                List admins = new ArrayList();
                if (this.hideAdminGroups) {
                    admins = this.userManager.getAdministratorsGroups();
                }
                block3: for (DocumentModel group : groupList) {
                    Object adminGroupName2;
                    if (this.hideAdminGroups) {
                        for (Object adminGroupName2 : admins) {
                            if (!((String)adminGroupName2).equals(group.getId())) continue;
                            break block3;
                        }
                    }
                    if (this.hidePowerUsersGroup && POWERUSERS.equals(group.getId())) break;
                    LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
                    adminGroupName2 = schema.getFields().iterator();
                    while (adminGroupName2.hasNext()) {
                        Field field = (Field)adminGroupName2.next();
                        QName fieldName = field.getName();
                        String key = fieldName.getLocalName();
                        Serializable value = group.getPropertyValue(fieldName.getPrefixedName());
                        obj.put(key, value);
                    }
                    String groupId = group.getId();
                    obj.put("id", groupId);
                    obj.put("entity-type", "group");
                    SuggestConstants.computeGroupLabel(obj, groupId, this.userManager.getGroupLabelField(), this.hideFirstLabel);
                    obj.put("type", "GROUP_TYPE");
                    obj.put("prefixed_id", "group:" + groupId);
                    SuggestConstants.computeUserGroupIcon(obj, this.hideIcon);
                    result.add(obj);
                }
                groupSize = result.size() - userSize;
            }
            if (limit <= 0) return Blobs.createJSONBlobFromValue(result);
            if (userSize > limit) throw new SizeLimitExceededException();
            if (groupSize > limit) throw new SizeLimitExceededException();
            if (userSize + groupSize <= limit) return Blobs.createJSONBlobFromValue(result);
            throw new SizeLimitExceededException();
        }
        catch (SizeLimitExceededException e) {
            return this.searchOverflowMessage();
        }
    }

    protected List<Map<String, Object>> usersToMapWithGroupRestrictions(DocumentModelList userList) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Schema schema = this.schemaManager.getSchema(this.userManager.getUserSchemaName());
        Directory userDir = this.directoryService.getDirectory(this.userManager.getUserDirectoryName());
        for (DocumentModel user : userList) {
            LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
            for (Field field : schema.getFields()) {
                QName fieldName = field.getName();
                String key = fieldName.getLocalName();
                Serializable value = user.getPropertyValue(fieldName.getPrefixedName());
                if (key.equals(userDir.getPasswordField())) continue;
                obj.put(key, value);
            }
            String userId = user.getId();
            obj.put("id", userId);
            obj.put("entity-type", "user");
            obj.put("type", "USER_TYPE");
            obj.put("prefixed_id", "user:" + userId);
            SuggestConstants.computeUserLabel(obj, this.firstLabelField, this.secondLabelField, this.thirdLabelField, this.hideFirstLabel, this.hideSecondLabel, this.hideThirdLabel, this.displayEmailInSuggestion, userId);
            SuggestConstants.computeUserGroupIcon(obj, this.hideIcon);
            if (!StringUtils.isBlank((CharSequence)this.groupRestriction)) {
                user = this.userManager.getUserModel(userId);
                UserAdapter userAdapter = (UserAdapter)user.getAdapter(UserAdapter.class);
                List groups = userAdapter.getGroups();
                if (groups == null || !groups.contains(this.groupRestriction)) continue;
                result.add(obj);
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    protected DocumentModelList searchUsers(long limit) {
        if (StringUtils.isBlank((CharSequence)this.prefix)) {
            return this.userManager.searchUsers(this.prefix);
        }
        String[] searchTerms = this.prefix.trim().split("\\s", 2);
        List predicates = Arrays.stream(searchTerms).map(this::getUserSearchPredicate).collect(Collectors.toList());
        DocumentModelList users = this.searchUsers(new MultiExpression(Operator.AND, predicates), limit);
        if (users.isEmpty()) {
            users = this.searchUsers(this.getUserSearchPredicate(this.prefix), limit);
        }
        return users;
    }

    protected DocumentModelList searchUsers(MultiExpression multiExpression, long limit) {
        QueryBuilder queryBuilder = new QueryBuilder();
        queryBuilder.filter(multiExpression);
        if (limit > 0L) {
            queryBuilder.limit(limit + 1L);
        }
        String sortField = StringUtils.defaultString((String)this.userManager.getUserSortField(), (String)this.userManager.getUserIdField());
        queryBuilder.order(OrderByExprs.asc((String)sortField));
        return this.userManager.searchUsers(queryBuilder);
    }

    protected MultiExpression getUserSearchPredicate(String prefix) {
        String pattern = prefix.trim() + "%";
        List predicates = this.userManager.getUserSearchFields().stream().map(key -> Predicates.ilike((String)key, (Object)pattern)).collect(Collectors.toList());
        return new MultiExpression(Operator.OR, predicates);
    }

    private Blob searchOverflowMessage() throws IOException {
        String label = I18NUtils.getMessageString((String)"messages", (String)"label.security.searchOverFlow", (Object[])new Object[0], (Locale)this.getLocale());
        Map<String, String> obj = Collections.singletonMap("displayLabel", label);
        return Blobs.createJSONBlobFromValue(Collections.singletonList(obj));
    }

    protected String getLang() {
        if (this.lang == null) {
            this.lang = (String)this.ctx.get((Object)"lang");
            if (this.lang == null) {
                this.lang = "en";
            }
        }
        return this.lang;
    }

    protected Locale getLocale() {
        return new Locale(this.getLang());
    }
}

