/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.avro;

import java.util.Arrays;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.runtime.avro.AvroSchemaFactory;
import org.nuxeo.runtime.avro.AvroSchemaFactoryContext;

public class DocumentModelSchemaFactory
extends AvroSchemaFactory<DocumentModel> {
    public DocumentModelSchemaFactory(AvroSchemaFactoryContext context) {
        super(context);
    }

    public Schema createSchema(DocumentModel input) {
        Schema typeSchema = this.context.createSchema((Object)input.getDocumentType());
        Schema schema = Schema.createRecord((String)this.getName(input), null, (String)"ecm", (boolean)false);
        new LogicalType("documentModel").addToSchema(schema);
        schema.setFields(Arrays.asList(new Schema.Field("uuid", Schema.create((Schema.Type)Schema.Type.STRING), null, null), new Schema.Field("path", Schema.create((Schema.Type)Schema.Type.STRING), null, null), new Schema.Field("name", Schema.create((Schema.Type)Schema.Type.STRING), null, null), new Schema.Field("title", Schema.create((Schema.Type)Schema.Type.STRING), null, null), new Schema.Field("repository", Schema.create((Schema.Type)Schema.Type.STRING), null, null), new Schema.Field("primaryType", Schema.create((Schema.Type)Schema.Type.STRING), null, null), new Schema.Field("changeToken", Schema.create((Schema.Type)Schema.Type.STRING), null, null), new Schema.Field("currentLifeCycleState", Schema.create((Schema.Type)Schema.Type.STRING), null, null), new Schema.Field("isProxy", Schema.create((Schema.Type)Schema.Type.BOOLEAN), null, null), new Schema.Field("isTrashed", Schema.create((Schema.Type)Schema.Type.BOOLEAN), null, null), new Schema.Field("isVersion", Schema.create((Schema.Type)Schema.Type.BOOLEAN), null, null), new Schema.Field("isCheckedIn", Schema.create((Schema.Type)Schema.Type.BOOLEAN), null, null), new Schema.Field("isLatestVersion", Schema.create((Schema.Type)Schema.Type.BOOLEAN), null, null), new Schema.Field("isLatestMajorVersion", Schema.create((Schema.Type)Schema.Type.BOOLEAN), null, null), new Schema.Field("parentId", this.nullable(Schema.create((Schema.Type)Schema.Type.STRING)), null, null), new Schema.Field("versionLabel", this.nullable(Schema.create((Schema.Type)Schema.Type.STRING)), null, null), new Schema.Field("versionVersionableId", this.nullable(Schema.create((Schema.Type)Schema.Type.STRING)), null, null), new Schema.Field("pos", this.nullable(Schema.create((Schema.Type)Schema.Type.LONG)), null, null), new Schema.Field("mixinType", this.nullable(Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.STRING))), null, null), new Schema.Field("tag", this.nullable(Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.STRING))), null, null), new Schema.Field("documentType", typeSchema, null, null)));
        return schema;
    }

    public String getName(DocumentModel input) {
        return this.context.getService().encodeName(input.getName());
    }
}

