/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.nuxeo.ecm.core.api.CloseableCoreSession;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.io.DocumentReader;
import org.nuxeo.ecm.core.io.DocumentTranslationMap;
import org.nuxeo.ecm.core.io.DocumentWriter;
import org.nuxeo.ecm.core.io.IODocumentManager;
import org.nuxeo.ecm.core.io.impl.AbstractDocumentModelWriter;
import org.nuxeo.ecm.core.io.impl.DocumentPipeImpl;
import org.nuxeo.ecm.core.io.impl.DocumentTranslationMapImpl;
import org.nuxeo.ecm.core.io.impl.plugins.DocumentModelWriter;
import org.nuxeo.ecm.core.io.impl.plugins.DocumentTreeReader;
import org.nuxeo.ecm.core.io.impl.plugins.DocumentsListReader;
import org.nuxeo.ecm.core.io.impl.plugins.NuxeoArchiveReader;
import org.nuxeo.ecm.core.io.impl.plugins.NuxeoArchiveWriter;

public class IODocumentManagerImpl
implements IODocumentManager {
    private static final long serialVersionUID = -3131999198524020179L;

    @Override
    public DocumentTranslationMap importDocuments(InputStream in, String repo, DocumentRef root) {
        DocumentReader reader = null;
        AbstractDocumentModelWriter writer = null;
        try {
            DocumentTranslationMap documentTranslationMap;
            block13: {
                CloseableCoreSession coreSession = CoreInstance.openCoreSessionSystem((String)repo);
                try {
                    DocumentModel dst = coreSession.getDocument(root);
                    reader = new NuxeoArchiveReader(in);
                    writer = new DocumentModelWriter((CoreSession)coreSession, dst.getPathAsString());
                    DocumentPipeImpl pipe = new DocumentPipeImpl(10);
                    pipe.setReader(reader);
                    pipe.setWriter(writer);
                    DocumentTranslationMap map = pipe.run();
                    coreSession.save();
                    documentTranslationMap = map;
                    if (coreSession == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (coreSession != null) {
                            try {
                                coreSession.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new NuxeoException((Throwable)e);
                    }
                }
                coreSession.close();
            }
            return documentTranslationMap;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    @Override
    public DocumentTranslationMap importDocuments(InputStream in, DocumentWriter customDocWriter) {
        try (NuxeoArchiveReader reader = null;){
            reader = new NuxeoArchiveReader(in);
            DocumentPipeImpl pipe = new DocumentPipeImpl(10);
            pipe.setReader(reader);
            pipe.setWriter(customDocWriter);
            DocumentTranslationMap map = pipe.run();
            customDocWriter.close();
            DocumentTranslationMap documentTranslationMap = map;
            return documentTranslationMap;
        }
    }

    @Override
    public DocumentTranslationMap exportDocuments(OutputStream out, String repo, Collection<DocumentRef> sources, boolean recurse, String format) {
        DocumentReader reader = null;
        DocumentWriter writer = null;
        try {
            DocumentTranslationMap documentTranslationMap;
            block18: {
                DocumentPipeImpl pipe;
                CloseableCoreSession coreSession;
                block16: {
                    DocumentTranslationMap documentTranslationMap2;
                    block17: {
                        coreSession = CoreInstance.openCoreSessionSystem((String)repo);
                        pipe = new DocumentPipeImpl(10);
                        writer = new NuxeoArchiveWriter(out);
                        pipe.setWriter(writer);
                        if (recurse) break block16;
                        reader = DocumentsListReader.createDocumentsListReader((CoreSession)coreSession, sources);
                        pipe.setReader(reader);
                        documentTranslationMap2 = pipe.run();
                        if (coreSession == null) break block17;
                        coreSession.close();
                    }
                    return documentTranslationMap2;
                }
                try {
                    ArrayList<DocumentTranslationMap> maps = new ArrayList<DocumentTranslationMap>();
                    for (DocumentRef rootSource : sources) {
                        reader = new DocumentTreeReader((CoreSession)coreSession, rootSource);
                        pipe.setReader(reader);
                        DocumentTranslationMap map = pipe.run();
                        if (map == null) continue;
                        maps.add(map);
                    }
                    documentTranslationMap = DocumentTranslationMapImpl.merge(maps);
                    if (coreSession == null) break block18;
                }
                catch (Throwable throwable) {
                    try {
                        if (coreSession != null) {
                            try {
                                coreSession.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new NuxeoException((Throwable)e);
                    }
                }
                coreSession.close();
            }
            return documentTranslationMap;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    @Override
    public DocumentTranslationMap exportDocuments(OutputStream out, DocumentReader customDocReader, String format) {
        try (DocumentWriter writer = null;){
            DocumentPipeImpl pipe = new DocumentPipeImpl(10);
            writer = new NuxeoArchiveWriter(out);
            pipe.setWriter(writer);
            pipe.setReader(customDocReader);
            ArrayList<DocumentTranslationMap> maps = new ArrayList<DocumentTranslationMap>();
            DocumentTranslationMap map = pipe.run();
            if (map != null) {
                maps.add(map);
            }
            DocumentTranslationMap documentTranslationMap = DocumentTranslationMapImpl.merge(maps);
            return documentTranslationMap;
        }
    }

    @Override
    public DocumentTranslationMap importDocuments(DocumentReader customDocReader, DocumentWriter customDocWriter) {
        try {
            DocumentPipeImpl pipe = new DocumentPipeImpl(10);
            pipe.setReader(customDocReader);
            pipe.setWriter(customDocWriter);
            DocumentTranslationMap map = pipe.run();
            return map;
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }
}

