/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.impl;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.dom4j.QName;
import org.nuxeo.common.collections.PrimitiveArrays;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.io.impl.ExportedDocumentImpl;
import org.nuxeo.ecm.core.schema.Namespace;
import org.nuxeo.ecm.core.schema.TypeConstants;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.BinaryType;
import org.nuxeo.ecm.core.schema.types.primitives.BooleanType;
import org.nuxeo.ecm.core.schema.types.primitives.DateType;
import org.nuxeo.ecm.core.schema.types.primitives.DoubleType;
import org.nuxeo.ecm.core.schema.types.primitives.IntegerType;
import org.nuxeo.ecm.core.schema.types.primitives.LongType;

public class TypedExportedDocumentImpl
extends ExportedDocumentImpl {
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String COMPLEX_TYPE_ID = "complex";
    private static final String SCALAR_LIST_TYPE_ID = "scalarList";
    private static final String COMPLEX_LIST_TYPE_ID = "complexList";
    private static final String CONTENT_LIST_TYPE_ID = "contentList";

    public TypedExportedDocumentImpl() {
    }

    public TypedExportedDocumentImpl(DocumentModel doc, Path path, boolean inlineBlobs) throws IOException {
        super(doc, path, inlineBlobs);
    }

    public TypedExportedDocumentImpl(DocumentModel doc) throws IOException {
        super(doc, false);
    }

    public TypedExportedDocumentImpl(DocumentModel doc, boolean inlineBlobs) throws IOException {
        super(doc, doc.getPath(), inlineBlobs);
    }

    @Override
    protected void readProperty(Element parent, Namespace targetNs, Field field, Object value, boolean inlineBlobs) throws IOException {
        Type type = field.getType();
        QName name = QName.get((String)field.getName().getLocalName(), (String)targetNs.prefix, (String)targetNs.uri);
        Element element = parent.addElement(name);
        if (type.isSimpleType()) {
            element.addAttribute(TYPE_ATTRIBUTE, this.getSimpleTypeId(type));
            if (value != null) {
                element.addText(type.encode(value));
            }
        } else if (type.isComplexType()) {
            ComplexType ctype = (ComplexType)type;
            if (TypeConstants.isContentType((Type)ctype)) {
                element.addAttribute(TYPE_ATTRIBUTE, "content");
                if (value != null) {
                    this.readBlob(element, ctype, (Blob)value, inlineBlobs);
                }
            } else {
                element.addAttribute(TYPE_ATTRIBUTE, COMPLEX_TYPE_ID);
                if (value != null) {
                    this.readComplex(element, ctype, (Map)value, inlineBlobs);
                }
            }
        } else if (type.isListType()) {
            ListType listType = (ListType)type;
            String typeId = listType.isScalarList() ? SCALAR_LIST_TYPE_ID : (TypeConstants.isContentType((Type)listType.getFieldType()) ? CONTENT_LIST_TYPE_ID : COMPLEX_LIST_TYPE_ID);
            element.addAttribute(TYPE_ATTRIBUTE, typeId);
            if (value != null) {
                if (value instanceof List) {
                    this.readList(element, (ListType)type, (List)value, inlineBlobs);
                } else if (value.getClass().getComponentType() != null) {
                    this.readList(element, (ListType)type, PrimitiveArrays.toList((Object)value), inlineBlobs);
                } else {
                    throw new IllegalArgumentException("A value of list type is neither list neither array: " + value);
                }
            }
        }
    }

    protected String getSimpleTypeId(Type type) {
        String typeId = "string";
        if (BooleanType.INSTANCE == type) {
            typeId = "boolean";
        } else if (DateType.INSTANCE == type) {
            typeId = "date";
        } else if (LongType.INSTANCE == type) {
            typeId = "long";
        } else if (IntegerType.INSTANCE == type) {
            typeId = "integer";
        } else if (DoubleType.INSTANCE == type) {
            typeId = "double";
        } else if (BinaryType.INSTANCE == type) {
            typeId = "binary";
        }
        return typeId;
    }
}

