/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.impl.transformers;

import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.nuxeo.ecm.core.io.DocumentTransformer;
import org.nuxeo.ecm.core.io.ExportedDocument;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.TypeConstants;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.runtime.api.Framework;

public class PropertyDeprecationRemover
implements DocumentTransformer {
    protected final SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);

    @Override
    public boolean transform(ExportedDocument xdoc) {
        Element root = xdoc.getDocument().getRootElement();
        for (Element schema : root.elements("schema")) {
            String schemaName = schema.attributeValue("name");
            for (String prop : this.schemaManager.getRemovedProperties(schemaName)) {
                this.handleProperty(schema, prop);
            }
        }
        return true;
    }

    protected void handleProperty(Element schema, String propertyToRemove) {
        String schemaName = schema.attributeValue("name");
        String namespaceURI = "http://www.nuxeo.org/ecm/schemas/" + schemaName + "/";
        String schemaPrefix = Optional.ofNullable(schema.getNamespaceForURI(namespaceURI)).map(Namespace::getPrefix).filter(StringUtils::isNotBlank).map(p -> p + ":").orElse("");
        Optional<String> fallback = this.schemaManager.getFallback(schemaName, propertyToRemove).map(f -> this.correctBlobProperty(schemaPrefix, (String)f));
        int starIndex = propertyToRemove.indexOf(42);
        if (starIndex < 0) {
            Element elementToRemove = (Element)schema.selectSingleNode(schemaPrefix + propertyToRemove);
            if (elementToRemove != null) {
                fallback.ifPresent(f -> this.moveProperty(schema, schema, elementToRemove, (String)f));
                elementToRemove.detach();
            }
        } else {
            List elementsToRemove = schema.selectNodes(schemaPrefix + propertyToRemove);
            int count = StringUtils.countMatches((CharSequence)propertyToRemove.substring(starIndex), (CharSequence)"/");
            Optional<String> newFallback = fallback.map(f -> f.substring(f.lastIndexOf("*/") + 2));
            for (Element elementToRemove : elementsToRemove) {
                newFallback.ifPresent(f -> this.moveProperty(schema, this.getParent(count, elementToRemove), elementToRemove, (String)f));
                elementToRemove.detach();
            }
        }
    }

    private String correctBlobProperty(String schemaPrefix, String path) {
        Field fallbackField = this.schemaManager.getField(schemaPrefix + path);
        if (fallbackField != null && TypeConstants.isContentType((Type)fallbackField.getDeclaringType())) {
            path = path.replace("/name", "/filename");
        }
        return path;
    }

    protected Element getParent(int count, Element elementToRemove) {
        Element parent = elementToRemove;
        for (int i = 0; i < count; ++i) {
            parent = parent.getParent();
        }
        return parent;
    }

    protected void moveProperty(Element schema, Element parent, Element elementToRemove, String fallback) {
        String[] fallbackSegments;
        for (String fallbackSegment : fallbackSegments = fallback.split("/")) {
            QName qName = parent == schema ? QName.get((String)fallbackSegment, (Namespace)schema.getNamespaceForPrefix(schema.attributeValue("name"))) : QName.get((String)fallbackSegment);
            Element element = parent.element(qName);
            if (element == null) {
                element = DocumentHelper.createElement((QName)qName);
                parent.add(element);
            }
            parent = element;
        }
        if (!parent.hasContent()) {
            parent.setContent(elementToRemove.content());
        }
    }
}

