/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json.document;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.DataModelImpl;
import org.nuxeo.ecm.core.api.impl.SimpleDocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.api.model.ReadOnlyPropertyException;
import org.nuxeo.ecm.core.api.model.impl.primitives.BlobProperty;
import org.nuxeo.ecm.core.io.marshallers.json.EntityJsonReader;
import org.nuxeo.ecm.core.io.registry.Reader;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.runtime.api.Framework;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class DocumentModelJsonReader
extends EntityJsonReader<DocumentModel> {
    private static final Logger log = LogManager.getLogger(DocumentModelJsonReader.class);
    public static final String LEGACY_MODE_READER = "DocumentModelLegacyModeReader";

    public DocumentModelJsonReader() {
        super("document");
    }

    @Override
    public DocumentModel read(Class<?> clazz, Type genericType, MediaType mediaType, InputStream in) throws IOException {
        Reader reader = (Reader)this.ctx.getParameter(LEGACY_MODE_READER);
        if (reader != null) {
            return (DocumentModel)reader.read(clazz, genericType, mediaType, in);
        }
        return (DocumentModel)super.read(clazz, genericType, mediaType, in);
    }

    @Override
    protected DocumentModel readEntity(JsonNode jn) throws IOException {
        SimpleDocumentModel doc;
        String uid;
        JsonNode propsNode;
        String type;
        SimpleDocumentModel simpleDoc = new SimpleDocumentModel();
        String name = this.getStringField(jn, "name");
        if (StringUtils.isNotBlank((CharSequence)name)) {
            simpleDoc.setPathInfo(null, name);
        }
        if (StringUtils.isNotBlank((CharSequence)(type = this.getStringField(jn, "type")))) {
            simpleDoc.setType(type);
        }
        if ((propsNode = jn.get("properties")) != null && !propsNode.isNull() && propsNode.isObject()) {
            ParameterizedType genericType = TypeUtils.parameterize(List.class, (Type[])new Type[]{Property.class});
            List properties = (List)this.readEntity(List.class, genericType, propsNode);
            for (Property property : properties) {
                Object propertyName = property.getName();
                if (!((String)propertyName).contains(":")) {
                    propertyName = property.getField().getDeclaringType().getName() + ":" + (String)propertyName;
                }
                String pn = propertyName;
                Framework.doPrivileged(() -> simpleDoc.setPropertyValue(pn, property.getValue()));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(uid = this.getStringField(jn, "uid")))) {
            try (RenderingContext.SessionWrapper wrapper = this.ctx.getSession(null);){
                doc = wrapper.getSession().getDocument((DocumentRef)new IdRef(uid));
            }
            DocumentModelJsonReader.applyDirtyPropertyValues((DocumentModel)simpleDoc, (DocumentModel)doc);
            String changeToken = this.getStringField(jn, "changeToken");
            doc.putContextData("changeToken", (Serializable)((Object)changeToken));
        } else if (StringUtils.isNotBlank((CharSequence)type)) {
            SimpleDocumentModel createdDoc = new SimpleDocumentModel();
            if (StringUtils.isNotBlank((CharSequence)name)) {
                createdDoc.setPathInfo(null, name);
            }
            createdDoc.setType(simpleDoc.getType());
            DocumentModelJsonReader.applyAllPropertyValues((DocumentModel)simpleDoc, (DocumentModel)createdDoc);
            doc = createdDoc;
        } else {
            doc = simpleDoc;
        }
        return doc;
    }

    public static void applyPropertyValues(DocumentModel src, DocumentModel dst) {
        DocumentModelJsonReader.applyPropertyValues(src, dst, true);
        dst.getContextData().putAll(src.getContextData());
    }

    public static void applyPropertyValues(DocumentModel src, DocumentModel dst, boolean dirtyOnly) {
        if (dirtyOnly) {
            DocumentModelJsonReader.applyDirtyPropertyValues(src, dst);
        } else {
            DocumentModelJsonReader.applyAllPropertyValues(src, dst);
        }
    }

    public static void applyDirtyPropertyValues(DocumentModel src, DocumentModel dst) {
        String[] schemas;
        for (String schema : schemas = src.getSchemas()) {
            DataModelImpl dstDataModel = (DataModelImpl)dst.getDataModel(schema);
            DataModelImpl srcDataModel = (DataModelImpl)src.getDataModel(schema);
            for (String field : srcDataModel.getDirtyFields()) {
                DocumentModelJsonReader.applyPropertyValue(srcDataModel, dstDataModel, field);
            }
        }
    }

    public static void applyAllPropertyValues(DocumentModel src, DocumentModel dst) {
        String[] schemas;
        SchemaManager service = (SchemaManager)Framework.getService(SchemaManager.class);
        DocumentType type = service.getDocumentType(src.getType());
        for (String schemaName : schemas = type.getSchemaNames()) {
            Schema schema = service.getSchema(schemaName);
            DataModelImpl dstDataModel = (DataModelImpl)dst.getDataModel(schemaName);
            DataModelImpl srcDataModel = (DataModelImpl)src.getDataModel(schemaName);
            for (Field field : schema.getFields()) {
                String fieldName = field.getName().getLocalName();
                DocumentModelJsonReader.applyPropertyValue(srcDataModel, dstDataModel, fieldName);
            }
        }
    }

    protected static void applyPropertyValue(DataModelImpl srcDataModel, DataModelImpl dstDataModel, String fieldName) {
        Serializable data = (Serializable)srcDataModel.getData(fieldName);
        try {
            if (!(dstDataModel.getDocumentPart().get(fieldName) instanceof BlobProperty)) {
                dstDataModel.setData(fieldName, (Object)data);
            } else {
                dstDataModel.setData(fieldName, (Object)DocumentModelJsonReader.decodeBlob(data));
            }
        }
        catch (PropertyNotFoundException | ReadOnlyPropertyException e) {
            log.trace("Can't apply value: {} to src: {}", (Object)data, (Object)srcDataModel, (Object)e);
        }
    }

    private static Serializable decodeBlob(Serializable data) {
        if (data instanceof Blob) {
            return data;
        }
        return null;
    }
}

