/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json.types;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.lang.reflect.Type;
import javax.ws.rs.core.MediaType;
import org.nuxeo.ecm.core.io.marshallers.json.ExtensibleEntityJsonWriter;
import org.nuxeo.ecm.core.io.marshallers.json.OutputStreamWithJsonWriter;
import org.nuxeo.ecm.core.io.registry.Writer;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.types.Schema;

@Setup(mode=Instantiations.SINGLETON, priority=2001)
public class DocumentTypeJsonWriter
extends ExtensibleEntityJsonWriter<DocumentType> {
    public static final String ENTITY_TYPE = "docType";

    public DocumentTypeJsonWriter() {
        super(ENTITY_TYPE, DocumentType.class);
    }

    @Override
    protected void writeEntityBody(DocumentType docType, JsonGenerator jg) throws IOException {
        jg.writeStringField("name", docType.getName());
        if (docType.getSuperType() != null) {
            jg.writeStringField("parent", docType.getSuperType().getName());
        } else {
            jg.writeNullField("parent");
        }
        jg.writeArrayFieldStart("facets");
        for (String facet : docType.getFacets()) {
            jg.writeString(facet);
        }
        jg.writeEndArray();
        jg.writeArrayFieldStart("schemas");
        Writer<Schema> schemaWriter = this.registry.getWriter(this.ctx, Schema.class, MediaType.APPLICATION_JSON_TYPE);
        for (Schema schema : docType.getSchemas()) {
            OutputStreamWithJsonWriter out = new OutputStreamWithJsonWriter(jg);
            schemaWriter.write(schema, Schema.class, (Type)((Object)Schema.class), MediaType.APPLICATION_JSON_TYPE, out);
        }
        jg.writeEndArray();
    }
}

