/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.registry.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.io.registry.Marshaller;
import org.nuxeo.ecm.core.io.registry.MarshallingException;
import org.nuxeo.ecm.core.io.registry.Reader;
import org.nuxeo.ecm.core.io.registry.Writer;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.context.RenderingContextImpl;
import org.nuxeo.ecm.core.io.registry.context.ThreadSafeRenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.core.io.registry.reflect.Supports;
import org.nuxeo.runtime.api.Framework;

public class MarshallerInspector
implements Comparable<MarshallerInspector> {
    private static final Log log = LogFactory.getLog(MarshallerInspector.class);
    private Class<?> clazz;
    private Integer priority;
    private Instantiations instantiation;
    private List<MediaType> supports = new ArrayList<MediaType>();
    private Constructor<?> constructor;
    private List<Field> serviceFields = new ArrayList<Field>();
    private List<Field> contextFields = new ArrayList<Field>();
    private Object singleton;
    private volatile boolean servicesInjected;
    private ThreadLocal<Object> threadInstance;
    private Class<?> marshalledType;
    private Type genericType;

    public MarshallerInspector(Class<?> clazz) {
        this.clazz = clazz;
        this.load();
    }

    private void load() {
        for (Constructor<?> constructor : this.clazz.getDeclaredConstructors()) {
            if (!Modifier.isPublic(constructor.getModifiers()) || constructor.getParameterTypes().length != 0) continue;
            this.constructor = constructor;
            break;
        }
        if (this.constructor == null) {
            throw new MarshallingException("No public constructor found for class " + this.clazz.getName() + ". Instanciation will not be possible.");
        }
        Setup setup = this.loadSetup(this.clazz);
        if (setup == null) {
            throw new MarshallingException("No required @Setup annotation found for class " + this.clazz.getName() + ". Instanciation will not be possible.");
        }
        if (!this.isReader() && !this.isWriter()) {
            throw new MarshallingException("MarshallerInspector only supports Reader and Writer: you must implement one of this interface for this class: " + this.clazz.getName());
        }
        if (this.isReader() && this.isWriter()) {
            throw new MarshallingException("MarshallerInspector only supports either Reader or Writer: you must implement only one of this interface: " + this.clazz.getName());
        }
        this.instantiation = setup.mode();
        this.priority = setup.priority();
        Supports supports = this.loadSupports(this.clazz);
        if (supports != null) {
            for (String mimetype : supports.value()) {
                try {
                    MediaType mediaType = MediaType.valueOf((String)mimetype);
                    this.supports.add(mediaType);
                }
                catch (IllegalArgumentException e) {
                    log.warn((Object)("In marshaller class " + this.clazz.getName() + ", the declared mediatype " + mimetype + " cannot be parsed as a mimetype"));
                }
            }
        }
        if (this.supports.isEmpty()) {
            log.warn((Object)("The marshaller " + this.clazz.getName() + " does not support any mimetype. You can add some using annotation @Supports"));
        }
        this.loadMarshalledType(this.clazz);
        this.loadInjections(this.clazz);
        if (this.contextFields.size() > 1) {
            log.warn((Object)("The marshaller " + this.clazz.getName() + " has more than one context injected property. You probably should use a context from a parent class."));
        }
        if (this.instantiation == Instantiations.SINGLETON) {
            this.singleton = this.getNewInstance(null, true);
        }
    }

    private void loadMarshalledType(Class<?> clazz) {
        if (this.isWriter() || this.isReader()) {
            Map typeArguments = TypeUtils.getTypeArguments(clazz, Marshaller.class);
            for (Map.Entry entry : typeArguments.entrySet()) {
                if (!Marshaller.class.equals(((TypeVariable)entry.getKey()).getGenericDeclaration())) continue;
                this.genericType = TypeUtils.unrollVariables((Map)typeArguments, (Type)((Type)entry.getValue()));
                this.marshalledType = TypeUtils.getRawType((Type)this.genericType, null);
                break;
            }
        }
    }

    private Setup loadSetup(Class<?> clazz) {
        if (Object.class.equals(clazz)) {
            return null;
        }
        return clazz.getAnnotation(Setup.class);
    }

    private Supports loadSupports(Class<?> clazz) {
        if (Object.class.equals(clazz)) {
            return null;
        }
        Supports supports = clazz.getAnnotation(Supports.class);
        if (supports != null) {
            return supports;
        }
        return this.loadSupports(clazz.getSuperclass());
    }

    private void loadInjections(Class<?> clazz) {
        if (Object.class.equals(clazz)) {
            return;
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Inject.class)) continue;
            if (RenderingContext.class.equals(field.getType())) {
                field.setAccessible(true);
                this.contextFields.add(field);
                continue;
            }
            field.setAccessible(true);
            this.serviceFields.add(field);
        }
        this.loadInjections(clazz.getSuperclass());
    }

    public <T> T getInstance(RenderingContext ctx) {
        RenderingContext realCtx = this.getRealContext(ctx);
        switch (this.instantiation) {
            case SINGLETON: {
                return (T)this.getSingletonInstance(realCtx);
            }
            case PER_THREAD: {
                return (T)this.getThreadInstance(realCtx);
            }
            case EACH_TIME: {
                return (T)this.getNewInstance(realCtx, false);
            }
        }
        throw new NuxeoException("unable to create a marshaller instance for clazz " + this.clazz.getName());
    }

    private RenderingContext getRealContext(RenderingContext ctx) {
        if (ctx == null) {
            return RenderingContext.CtxBuilder.get();
        }
        if (ctx instanceof RenderingContextImpl) {
            return ctx;
        }
        if (ctx instanceof ThreadSafeRenderingContext) {
            RenderingContext delegate = ((ThreadSafeRenderingContext)ctx).getDelegate();
            return this.getRealContext(delegate);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getSingletonInstance(RenderingContext ctx) {
        if (!this.servicesInjected) {
            MarshallerInspector marshallerInspector = this;
            synchronized (marshallerInspector) {
                if (!this.servicesInjected) {
                    this.injectServices(this.singleton);
                    this.servicesInjected = true;
                }
            }
        }
        for (Field contextField : this.contextFields) {
            ThreadSafeRenderingContext value;
            try {
                value = (ThreadSafeRenderingContext)contextField.get(this.singleton);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new NuxeoException("unable to create a marshaller instance for clazz " + this.clazz.getName(), (Throwable)e);
            }
            value.configureThread(ctx);
        }
        return this.singleton;
    }

    private Object getThreadInstance(RenderingContext ctx) {
        Object instance;
        if (this.threadInstance == null) {
            this.threadInstance = new ThreadLocal();
        }
        if ((instance = this.threadInstance.get()) == null) {
            instance = this.getNewInstance(ctx, false);
            this.threadInstance.set(instance);
        } else {
            for (Field contextField : this.contextFields) {
                try {
                    contextField.set(instance, ctx);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    throw new NuxeoException("unable to create a marshaller instance for clazz " + this.clazz.getName(), (Throwable)e);
                }
            }
        }
        return instance;
    }

    public Object getNewInstance(RenderingContext ctx, boolean singleton) {
        try {
            Object instance = this.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (!singleton) {
                this.injectServices(instance);
            }
            this.injectCtx(instance, ctx, singleton);
            return instance;
        }
        catch (ReflectiveOperationException e) {
            throw new NuxeoException("unable to create a marshaller instance for clazz " + this.clazz.getName(), (Throwable)e);
        }
    }

    public void injectCtx(Object instance, RenderingContext ctx, boolean singleton) {
        try {
            for (Field contextField : this.contextFields) {
                if (singleton) {
                    ThreadSafeRenderingContext safeCtx = new ThreadSafeRenderingContext();
                    safeCtx.configureThread(ctx);
                    contextField.set(instance, safeCtx);
                    continue;
                }
                contextField.set(instance, ctx);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new NuxeoException("unable to inject the ctx in the marshaller instance for clazz " + this.clazz.getName(), (Throwable)e);
        }
    }

    public void injectServices(Object instance) {
        try {
            for (Field serviceField : this.serviceFields) {
                Object service = Framework.getService(serviceField.getType());
                if (service == null) {
                    throw new NuxeoException("unable to inject a service " + serviceField.getType().getName() + " in the marshaller clazz " + this.clazz.getName());
                }
                serviceField.set(instance, service);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new NuxeoException("unable to inject the services in the marshaller instance for clazz " + this.clazz.getName(), (Throwable)e);
        }
    }

    public Instantiations getInstantiations() {
        return this.instantiation;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public List<MediaType> getSupports() {
        return this.supports;
    }

    public Class<?> getMarshalledType() {
        return this.marshalledType;
    }

    public Type getGenericType() {
        return this.genericType;
    }

    public boolean isMarshaller() {
        return Marshaller.class.isAssignableFrom(this.clazz);
    }

    public boolean isWriter() {
        return Writer.class.isAssignableFrom(this.clazz);
    }

    public boolean isReader() {
        return Reader.class.isAssignableFrom(this.clazz);
    }

    @Override
    public int compareTo(MarshallerInspector inspector) {
        if (inspector != null) {
            int result = this.getPriority().compareTo(inspector.getPriority());
            if (result != 0) {
                return -result;
            }
            result = this.getInstantiations().compareTo(inspector.getInstantiations());
            if (result != 0) {
                return -result;
            }
            if (this.isMarshaller() && inspector.isMarshaller() && !this.getMarshalledType().equals(inspector.getMarshalledType())) {
                if (this.getMarshalledType().isAssignableFrom(inspector.getMarshalledType())) {
                    return 1;
                }
                if (inspector.getMarshalledType().isAssignableFrom(this.getMarshalledType())) {
                    return -1;
                }
            }
            if (!this.clazz.equals(inspector.clazz)) {
                if (this.clazz.isAssignableFrom(inspector.clazz)) {
                    return -1;
                }
                if (inspector.clazz.isAssignableFrom(this.clazz)) {
                    return 1;
                }
            }
            if (this.isWriter() && inspector.isWriter() || this.isReader() && inspector.isReader()) {
                boolean mineIsTop = MarshallerInspector.isTopPriority(this.genericType);
                boolean thatIsTop = MarshallerInspector.isTopPriority(inspector.genericType);
                if (mineIsTop && !thatIsTop) {
                    return -1;
                }
                if (!mineIsTop && thatIsTop) {
                    return 1;
                }
                boolean mineIsBig = MarshallerInspector.isBigPriority(this.genericType);
                boolean thatIsBig = MarshallerInspector.isBigPriority(inspector.genericType);
                if (mineIsBig && !thatIsBig) {
                    return -1;
                }
                if (!mineIsBig && thatIsBig) {
                    return 1;
                }
            }
            return -this.clazz.getName().compareTo(inspector.clazz.getName());
        }
        return 1;
    }

    private static boolean isTopPriority(Type type) {
        return TypeUtils.isAssignable((Type)type, DocumentModel.class) || TypeUtils.isAssignable((Type)type, Property.class);
    }

    private static boolean isBigPriority(Type type) {
        return TypeUtils.isAssignable((Type)type, NuxeoPrincipal.class) || TypeUtils.isAssignable((Type)type, NuxeoGroup.class) || TypeUtils.isAssignable((Type)type, (Type)TypeUtils.parameterize(List.class, (Type[])new Type[]{DocumentModel.class}));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clazz == null ? 0 : this.clazz.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MarshallerInspector)) {
            return false;
        }
        MarshallerInspector other = (MarshallerInspector)obj;
        return this.clazz.equals(other.clazz);
    }
}

