/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.cudf.solver;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class TwoTierMap
implements Map<Object, Object>,
Serializable {
    private static final long serialVersionUID = 362497720873186265L;
    private Map<Object, Map<Object, Object>> outerMap;
    private int policy;
    public static final int POLICY_NONE = 0;
    public static final int POLICY_BOTH_MAPS_PRESERVE_ORDERING = 1;
    public static final int POLICY_INNER_MAP_PRESERVE_EXISTING = 2;
    public static final int POLICY_INNER_MAP_SORTED_ASCENDING = 4;
    public static final int POLICY_INNER_MAP_SORTED_DESCENDING = 8;
    public static final int POLICY_INNER_MAP_ENSURE_SINGLETON = 16;
    private static final int POLICY_INNER_MAP_SORTED_MASK = 12;

    public TwoTierMap() {
        this(8, 0);
    }

    public TwoTierMap(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public TwoTierMap(int initialCapacity, int policy) {
        this.policy = policy;
        this.outerMap = this.shouldUseOrderedMap() ? new LinkedHashMap(initialCapacity) : new HashMap(initialCapacity);
    }

    public Object put(Object key1, Object key2, Object value) {
        Object existing;
        Map<Object, Object> innerMap = this.outerMap.get(key1);
        if (innerMap == null) {
            if (this.shouldUseSingletonInnerMap()) {
                this.outerMap.put(key1, Collections.singletonMap(key2, value));
                return null;
            }
            innerMap = this.createInnerMap();
            this.outerMap.put(key1, innerMap);
        }
        if ((existing = innerMap.put(key2, value)) != null && this.shouldPreserveExisting()) {
            innerMap.put(key2, existing);
        }
        return existing;
    }

    public Object get(Object key1, Object key2) {
        if (key1 == null || key2 == null) {
            return this.getAll(key1);
        }
        Map<Object, Object> innerMap = this.outerMap.get(key1);
        Object value = innerMap == null ? null : innerMap.get(key2);
        return value;
    }

    public Collection<?> getAll(Object key1) {
        if (key1 == null) {
            return this.values();
        }
        Map<Object, Object> innerMap = this.outerMap.get(key1);
        return innerMap == null ? Collections.EMPTY_LIST : Collections.unmodifiableCollection(innerMap.values());
    }

    public Object remove(Object key1, Object key2) {
        if (key1 == null || key2 == null) {
            return this.removeAll(key1);
        }
        Map<Object, Object> innerMap = this.outerMap.get(key1);
        if (innerMap == null) {
            return null;
        }
        if (this.shouldUseSingletonInnerMap()) {
            Object result = innerMap.get(key2);
            if (result != null) {
                this.outerMap.remove(key1);
            }
            return result;
        }
        Object result = innerMap.remove(key2);
        if (result != null && innerMap.isEmpty()) {
            this.outerMap.remove(key1);
        }
        return result;
    }

    public Collection<?> removeAll(Object key1) {
        if (key1 == null) {
            return Collections.EMPTY_LIST;
        }
        Map<Object, Object> innerMap = this.outerMap.remove(key1);
        return innerMap == null ? Collections.EMPTY_LIST : innerMap.values();
    }

    public boolean containsKey(Object key1, Object key2) {
        if (key1 == null) {
            return false;
        }
        if (key2 == null) {
            return this.containsKey(key1);
        }
        return this.get(key1, key2) != null;
    }

    @Override
    public void clear() {
        this.outerMap.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.outerMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (Map.Entry entry : this.entrySet()) {
            Map innerMap = (Map)entry.getValue();
            if (!innerMap.containsValue(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.outerMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Set entrySet() {
        Set<Map.Entry<Object, Map<Object, Object>>> unmodifiableSet = Collections.unmodifiableSet(this.outerMap.entrySet());
        return unmodifiableSet;
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> result = new ArrayList<Object>(this.size());
        for (Object key : this.outerMap.keySet()) {
            if (key == null) continue;
            result.addAll(this.getAll(key));
        }
        return result;
    }

    @Override
    public Object get(Object key) {
        if (key instanceof Object[]) {
            Object[] keys = (Object[])key;
            return this.get(keys[0], keys[1]);
        }
        return this.getAll(key);
    }

    @Override
    public Set keySet() {
        return Collections.unmodifiableSet(this.outerMap.keySet());
    }

    @Override
    public Object put(Object key, Object value) {
        if (key instanceof Object[]) {
            Object[] keys = (Object[])key;
            return this.put(keys[0], keys[1], value);
        }
        throw new IllegalArgumentException("First arg should be an array!");
    }

    @Override
    public void putAll(Map<?, ?> t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(Object key) {
        if (key instanceof Object[]) {
            Object[] keys = (Object[])key;
            return this.remove(keys[0], keys[1]);
        }
        return this.removeAll(key);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.outerMap.isEmpty()) {
            sb.append("  (Empty)");
        } else {
            for (Map.Entry<Object, Map<Object, Object>> entry : this.outerMap.entrySet()) {
                sb.append("  ").append(entry.getKey()).append(" = ").append(entry.getValue()).append('\n');
            }
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public void dump(PrintStream ps) {
        if (ps == null) {
            ps = System.out;
        }
        ps.println(this.toString());
    }

    private Map<Object, Object> createInnerMap() {
        AbstractMap innerMap = this.shouldUseSortedInnerMap() ? new TreeMap(new ValueComparator(this.shouldSortInAscendingOrder())) : (this.shouldUseOrderedMap() ? new LinkedHashMap(2) : new HashMap(2));
        return innerMap;
    }

    private boolean shouldPreserveExisting() {
        return (this.policy & 2) == 2;
    }

    private boolean shouldUseOrderedMap() {
        return (this.policy & 1) == 1;
    }

    private boolean shouldUseSortedInnerMap() {
        return (this.policy & 0xC) != 0;
    }

    private boolean shouldSortInAscendingOrder() {
        return (this.policy & 0xC) == 4;
    }

    private boolean shouldUseSingletonInnerMap() {
        return (this.policy & 0x10) == 16;
    }

    private static class ValueComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 362497720873186266L;
        private boolean ascending;

        public ValueComparator(boolean ascending) {
            this.ascending = ascending;
        }

        public int compare(Object o1, Object o2) {
            try {
                if (o1 instanceof Comparable) {
                    int cmp = ((Comparable)o1).compareTo(o2);
                    return this.ascending ? cmp : 0 - cmp;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 1;
        }
    }
}

