/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.jaxrs.io.operations;

import java.io.IOException;
import org.nuxeo.ecm.automation.jaxrs.io.operations.InputResolver;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.BlobInfo;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.runtime.api.Framework;

public class BlobInputResolver
implements InputResolver<Blob> {
    @Override
    public String getType() {
        return "blob";
    }

    @Override
    public Blob getInput(String content) {
        return BlobInputResolver.blobFromKey(content);
    }

    public static Blob blobFromKey(String key) {
        try {
            int colon = key.indexOf(58);
            if (colon < 0) {
                throw new NuxeoException("Invalid blob key format: " + key);
            }
            String providerId = key.substring(0, colon);
            BlobProvider blobProvider = ((BlobManager)Framework.getService(BlobManager.class)).getBlobProvider(providerId);
            BlobInfo blobInfo = new BlobInfo();
            blobInfo.key = key;
            if (blobProvider.performsExternalAccessControl(blobInfo)) {
                return blobProvider.readBlob(blobInfo);
            }
            throw new NuxeoException("BlobProvider " + providerId + " cannot perform access control for key: " + key);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }
}

