/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.csv.export.validation;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.nuxeo.ecm.core.bulk.AbstractBulkActionValidation;
import org.nuxeo.ecm.core.bulk.message.BulkCommand;

public class CSVExportValidation
extends AbstractBulkActionValidation {
    protected List<String> getParametersToValidate() {
        return Arrays.asList("sort", "zip", "lang", "schemas", "xpaths");
    }

    protected void validateCommand(BulkCommand command) throws IllegalArgumentException {
        this.validateBoolean("sort", command);
        this.validateBoolean("zip", command);
        this.validateString("lang", command);
        String lang = (String)command.getParam("lang");
        if (lang != null && !Arrays.asList(Locale.getAvailableLocales()).contains(Locale.forLanguageTag(lang))) {
            throw new IllegalArgumentException(this.invalidParameterMessage("lang", command));
        }
        this.validateList("schemas", command);
        List schemas = (List)command.getParam("schemas");
        if (schemas != null) {
            for (Object schema : schemas) {
                this.validateSchema("schemas", (Serializable)schema, command);
            }
        }
        this.validateList("xpaths", command);
        List xpaths = (List)command.getParam("xpaths");
        if (xpaths != null) {
            for (Object xpath : xpaths) {
                this.validateXpath("xpaths", (Serializable)xpath, command);
            }
        }
    }
}

