/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.mongodb;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.GridFSBuckets;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.Updates;
import com.mongodb.gridfs.GridFS;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.blob.BlobInfo;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.core.blob.binary.AbstractBinaryManager;
import org.nuxeo.ecm.core.blob.binary.Binary;
import org.nuxeo.ecm.core.blob.binary.BinaryBlobProvider;
import org.nuxeo.ecm.core.blob.binary.BinaryGarbageCollector;
import org.nuxeo.ecm.core.blob.binary.BinaryManager;
import org.nuxeo.ecm.core.blob.binary.BinaryManagerStatus;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.mongodb.MongoDBConnectionService;

public class GridFSBinaryManager
extends AbstractBinaryManager
implements BlobProvider {
    public static final String BLOB_PROVIDER_CONNECTION_PREFIX = "blobProvider/";
    @Deprecated
    public static final String SERVER_PROPERTY = "server";
    @Deprecated
    public static final String DBNAME_PROPERTY = "dbname";
    public static final String BUCKET_PROPERTY = "bucket";
    private static final String METADATA_PROPERTY_FILENAME = "filename";
    private static final String METADATA_PROPERTY_METADATA = "metadata";
    private static final String METADATA_PROPERTY_LENGTH = "length";
    protected Map<String, String> properties;
    @Deprecated
    protected GridFS gridFS;
    protected GridFSBucket gridFSBucket;
    protected MongoCollection<Document> filesColl;

    public void initialize(String blobProviderId, Map<String, String> properties) throws IOException {
        super.initialize(blobProviderId, properties);
        this.properties = properties;
        if (StringUtils.isNotBlank((CharSequence)properties.get(SERVER_PROPERTY)) || StringUtils.isNotBlank((CharSequence)properties.get(DBNAME_PROPERTY))) {
            throw new NuxeoException("Unable to initialize GridFS Binary Manager, properties server and dbname has been removed. Please configure a connection!");
        }
        String namespace = properties.get("namespace");
        Object bucket = properties.get(BUCKET_PROPERTY);
        if (StringUtils.isBlank((CharSequence)bucket)) {
            bucket = StringUtils.isNotBlank((CharSequence)namespace) ? blobProviderId + "." + namespace.trim() : blobProviderId;
            bucket = (String)bucket + ".fs";
        } else if (StringUtils.isNotBlank((CharSequence)namespace)) {
            bucket = (String)bucket + "." + namespace.trim();
        }
        MongoDBConnectionService mongoService = (MongoDBConnectionService)Framework.getService(MongoDBConnectionService.class);
        MongoDatabase database = mongoService.getDatabase(BLOB_PROVIDER_CONNECTION_PREFIX + blobProviderId);
        this.gridFSBucket = GridFSBuckets.create((MongoDatabase)database, (String)bucket);
        this.filesColl = database.getCollection((String)bucket + ".files");
        this.garbageCollector = new GridFSBinaryGarbageCollector((String)bucket);
    }

    public void close() {
    }

    public BinaryManager getBinaryManager() {
        return this;
    }

    protected GridFSBucket getGridFSBucket() {
        return this.gridFSBucket;
    }

    public Binary getBinary(Blob blob) throws IOException {
        String digest;
        if (!(blob instanceof FileBlob)) {
            return super.getBinary(blob);
        }
        File file = blob.getFile();
        try (FileInputStream in = new FileInputStream(file);){
            digest = DigestUtils.md5Hex((InputStream)in);
        }
        GridFSFile dbFile = (GridFSFile)this.gridFSBucket.find(Filters.eq((String)METADATA_PROPERTY_FILENAME, (Object)digest)).first();
        if (dbFile == null) {
            try (FileInputStream in = new FileInputStream(file);){
                this.gridFSBucket.uploadFromStream(digest, (InputStream)in);
            }
        }
        return new GridFSBinary(digest, this.blobProviderId, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Binary getBinary(InputStream in) throws IOException {
        try {
            String inputName = "tmp-" + System.nanoTime();
            ObjectId id = this.gridFSBucket.uploadFromStream(inputName, in);
            GridFSFile inputFile = (GridFSFile)this.gridFSBucket.find(Filters.eq((String)METADATA_PROPERTY_FILENAME, (Object)inputName)).first();
            String digest = inputFile.getMD5();
            GridFSFile dbFile = (GridFSFile)this.gridFSBucket.find(Filters.eq((String)METADATA_PROPERTY_FILENAME, (Object)digest)).first();
            if (dbFile == null) {
                this.gridFSBucket.rename(id, digest);
            } else {
                this.gridFSBucket.delete(id);
            }
            GridFSBinary gridFSBinary = new GridFSBinary(digest, this.blobProviderId, this);
            return gridFSBinary;
        }
        finally {
            in.close();
        }
    }

    public Binary getBinary(String digest) {
        GridFSFile dbFile = (GridFSFile)this.gridFSBucket.find(Filters.eq((String)METADATA_PROPERTY_FILENAME, (Object)digest)).first();
        if (dbFile != null) {
            return new GridFSBinary(digest, this.blobProviderId, this);
        }
        return null;
    }

    public Blob readBlob(BlobInfo blobInfo) throws IOException {
        return new BinaryBlobProvider((BinaryManager)this).readBlob(blobInfo);
    }

    public String writeBlob(Blob blob) throws IOException {
        return new BinaryBlobProvider((BinaryManager)this).writeBlob(blob);
    }

    public boolean supportsUserUpdate() {
        return !Boolean.parseBoolean(this.properties.get("preventUserUpdate"));
    }

    public boolean isTransient() {
        return Boolean.parseBoolean(this.properties.get("transient"));
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public class GridFSBinaryGarbageCollector
    implements BinaryGarbageCollector {
        protected final String bucket;
        protected BinaryManagerStatus status;
        protected volatile long startTime;
        protected static final String MARK_KEY_PREFIX = "gc-mark-key-";
        protected String msKey;

        public GridFSBinaryGarbageCollector(String bucket) {
            this.bucket = bucket;
        }

        public String getId() {
            return "gridfs:" + this.bucket;
        }

        public BinaryManagerStatus getStatus() {
            return this.status;
        }

        public boolean isInProgress() {
            return this.startTime != 0L;
        }

        public void mark(String digest) {
            Document dbFile = (Document)GridFSBinaryManager.this.filesColl.findOneAndUpdate(Filters.eq((String)GridFSBinaryManager.METADATA_PROPERTY_FILENAME, (Object)digest), Updates.set((String)String.format("%s.%s", GridFSBinaryManager.METADATA_PROPERTY_METADATA, this.msKey), (Object)Boolean.TRUE), new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER));
            if (dbFile != null) {
                ++this.status.numBinaries;
                this.status.sizeBinaries += dbFile.getLong((Object)GridFSBinaryManager.METADATA_PROPERTY_LENGTH).longValue();
            }
        }

        public void start() {
            if (this.startTime != 0L) {
                throw new NuxeoException("Already started");
            }
            this.startTime = System.currentTimeMillis();
            this.status = new BinaryManagerStatus();
            this.msKey = MARK_KEY_PREFIX + System.currentTimeMillis();
        }

        public void stop(boolean delete) {
            GridFSBinaryManager.this.gridFSBucket.find(Filters.exists((String)String.format("%s.%s", GridFSBinaryManager.METADATA_PROPERTY_METADATA, this.msKey), (boolean)false)).forEach(file -> {
                ++this.status.numBinariesGC;
                this.status.sizeBinariesGC += file.getLength();
                if (delete) {
                    GridFSBinaryManager.this.gridFSBucket.delete(file.getId());
                }
            });
            this.startTime = 0L;
        }
    }

    protected static class GridFSBinary
    extends Binary {
        private static final long serialVersionUID = 1L;
        protected transient GridFSBinaryManager bm;

        protected GridFSBinary(String digest, String blobProviderId, GridFSBinaryManager bm) {
            super(digest, blobProviderId);
            this.bm = bm;
        }

        protected GridFSBinaryManager getBinaryManager() {
            if (this.bm == null) {
                if (this.blobProviderId == null) {
                    throw new UnsupportedOperationException("Cannot find binary manager, no blob provider id");
                }
                BlobManager blobManager = (BlobManager)Framework.getService(BlobManager.class);
                BlobProvider bp = blobManager.getBlobProvider(this.blobProviderId);
                this.bm = (GridFSBinaryManager)bp.getBinaryManager();
            }
            return this.bm;
        }

        public InputStream getStream() {
            return this.getBinaryManager().getGridFSBucket().openDownloadStream(this.digest);
        }

        protected File recomputeFile() {
            return null;
        }
    }
}

