/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.mongodb;

import com.mongodb.MongoClient;
import com.mongodb.MongoTimeoutException;
import com.mongodb.client.MongoDatabase;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.launcher.config.ConfigurationException;
import org.nuxeo.launcher.config.ConfigurationGenerator;
import org.nuxeo.launcher.config.backingservices.BackingChecker;
import org.nuxeo.runtime.mongodb.MongoDBConnectionConfig;
import org.nuxeo.runtime.mongodb.MongoDBConnectionHelper;

public class MongoDBChecker
implements BackingChecker {
    private static final Log log = LogFactory.getLog(MongoDBChecker.class);
    public static final String TEMPLATE_NAME = "mongodb";
    public static final String CONFIG_NAME = "mongodb-connection-config.xml";
    public static final String PARAM_MONGODB_CHECK_TIMEOUT = "nuxeo.mongodb.check.timeout";
    public static final int DEFAULT_CHECK_TIMEOUT_IN_SECONDS = 5;

    public boolean accepts(ConfigurationGenerator cg) {
        return cg.getTemplateList().contains(TEMPLATE_NAME);
    }

    public void check(ConfigurationGenerator cg) throws ConfigurationException {
        File configFile = new File(cg.getConfigDir(), CONFIG_NAME);
        if (!configFile.exists()) {
            log.warn((Object)"Unable to find config file mongodb-connection-config.xml");
            return;
        }
        MongoDBConnectionConfig config = this.getDescriptor(configFile, MongoDBConnectionConfig.class);
        try (MongoClient mongoClient = MongoDBConnectionHelper.newMongoClient((MongoDBConnectionConfig)config, builder -> builder.serverSelectionTimeout((int)TimeUnit.SECONDS.toMillis(this.getCheckTimeoutInSeconds(cg))).description("Nuxeo DB Check"));){
            MongoDatabase database = mongoClient.getDatabase(config.dbname);
            Document ping = new Document("ping", (Object)"1");
            database.runCommand((Bson)ping);
        }
        catch (MongoTimeoutException e) {
            throw new ConfigurationException(String.format("Unable to connect to MongoDB at %s, please check your connection", config.server));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T getDescriptor(File file, Class<T> klass) throws ConfigurationException {
        XMap xmap = new XMap();
        xmap.register(klass);
        try (FileInputStream inStream = new FileInputStream(file);){
            Object object = xmap.load((InputStream)inStream);
            return (T)object;
        }
        catch (IOException e) {
            throw new ConfigurationException("Unable to load the configuration for " + klass.getSimpleName(), (Throwable)e);
        }
    }

    private int getCheckTimeoutInSeconds(ConfigurationGenerator cg) {
        int checkTimeout = 5;
        try {
            checkTimeout = Integer.parseInt(cg.getUserConfig().getProperty(PARAM_MONGODB_CHECK_TIMEOUT, String.valueOf(5)));
        }
        catch (NumberFormatException e) {
            log.warn((Object)String.format("Invalid format for %s parameter, using default value instead", PARAM_MONGODB_CHECK_TIMEOUT), (Throwable)e);
        }
        return checkTimeout;
    }
}

