/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.mongodb;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.Document;
import org.nuxeo.ecm.core.api.model.Delta;
import org.nuxeo.ecm.core.storage.State;
import org.nuxeo.ecm.core.storage.mongodb.MongoDBRepository;

public class MongoDBConverter {
    protected final String idKey;

    public MongoDBConverter() {
        this(null);
    }

    public MongoDBConverter(String idKey) {
        this.idKey = idKey;
    }

    public List<Document> diffToBson(State.StateDiff diff) {
        UpdateBuilder updateBuilder = new UpdateBuilder();
        return updateBuilder.build(diff);
    }

    public String keyToBson(String key) {
        if (this.idKey == null) {
            return key;
        }
        return this.idKey.equals(key) ? "_id" : key;
    }

    public Object valueToBson(Object value) {
        if (value instanceof State) {
            return this.stateToBson((State)value);
        }
        if (value instanceof List) {
            List values = (List)value;
            return this.listToBson(values);
        }
        if (value instanceof Object[]) {
            return this.listToBson(Arrays.asList((Object[])value));
        }
        return this.serializableToBson(value);
    }

    public Document stateToBson(State state) {
        Document doc = new Document();
        for (Map.Entry en : state.entrySet()) {
            Object val = this.valueToBson(en.getValue());
            if (val == null) continue;
            doc.put(this.keyToBson((String)en.getKey()), val);
        }
        return doc;
    }

    public List<Object> listToBson(List<Object> values) {
        ArrayList<Object> objects = new ArrayList<Object>(values.size());
        for (Object value : values) {
            objects.add(this.valueToBson(value));
        }
        return objects;
    }

    public String bsonToKey(String key) {
        if (this.idKey == null) {
            return key;
        }
        return "_id".equals(key) ? this.idKey : key;
    }

    public State bsonToState(Document doc) {
        if (doc == null) {
            return null;
        }
        State state = new State(doc.keySet().size());
        for (String key : doc.keySet()) {
            if (this.idKey == null && "_id".equals(key)) continue;
            state.put(this.bsonToKey(key), this.bsonToValue(doc.get((Object)key)));
        }
        return state;
    }

    public Serializable bsonToValue(Object value) {
        if (value instanceof List) {
            List list = (List)value;
            if (list.isEmpty()) {
                return null;
            }
            Class klass = Object.class;
            for (Object o : list) {
                if (o == null) continue;
                klass = this.scalarToSerializableClass(o.getClass());
                break;
            }
            if (Document.class.isAssignableFrom(klass)) {
                ArrayList<State> l = new ArrayList<State>(list.size());
                for (Object el : list) {
                    l.add(this.bsonToState((Document)el));
                }
                return l;
            }
            Object[] ar = (Object[])Array.newInstance(klass, list.size());
            int i = 0;
            for (Object el : list) {
                ar[i++] = this.scalarToSerializable(el);
            }
            return ar;
        }
        if (value instanceof Document) {
            return this.bsonToState((Document)value);
        }
        return this.scalarToSerializable(value);
    }

    public Object serializableToBson(Object value) {
        if (value instanceof Calendar) {
            return ((Calendar)value).getTime();
        }
        return value;
    }

    public Serializable scalarToSerializable(Object val) {
        if (val instanceof Date) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)val);
            return cal;
        }
        return (Serializable)val;
    }

    public Class<?> scalarToSerializableClass(Class<?> klass) {
        if (Date.class.isAssignableFrom(klass)) {
            return Calendar.class;
        }
        return klass;
    }

    public class UpdateBuilder {
        protected final Document set = new Document();
        protected final Document unset = new Document();
        protected final Document push = new Document();
        protected final Document inc = new Document();
        protected final List<Document> updates = new ArrayList<Document>(10);
        protected Document update;
        protected Set<String> prefixKeys;
        protected Set<String> keys;

        public List<Document> build(State.StateDiff diff) {
            this.processStateDiff(diff, null);
            this.newUpdate();
            for (Map.Entry en : this.set.entrySet()) {
                this.update("$set", (String)en.getKey(), en.getValue());
            }
            for (Map.Entry en : this.unset.entrySet()) {
                this.update("$unset", (String)en.getKey(), en.getValue());
            }
            for (Map.Entry en : this.push.entrySet()) {
                this.update("$push", (String)en.getKey(), en.getValue());
            }
            for (Map.Entry en : this.inc.entrySet()) {
                this.update("$inc", (String)en.getKey(), en.getValue());
            }
            return this.updates;
        }

        protected void processStateDiff(State.StateDiff diff, String prefix) {
            Object elemPrefix = prefix == null ? "" : prefix + ".";
            for (Map.Entry en : diff.entrySet()) {
                String name = (String)elemPrefix + (String)en.getKey();
                Serializable value = (Serializable)en.getValue();
                if (value instanceof State.StateDiff) {
                    this.processStateDiff((State.StateDiff)value, name);
                    continue;
                }
                if (value instanceof State.ListDiff) {
                    this.processListDiff((State.ListDiff)value, name);
                    continue;
                }
                if (value instanceof Delta) {
                    this.processDelta((Delta)value, name);
                    continue;
                }
                this.processValue(name, value);
            }
        }

        protected void processListDiff(State.ListDiff listDiff, String prefix) {
            if (listDiff.diff != null) {
                Object elemPrefix = prefix == null ? "" : prefix + ".";
                int i = 0;
                for (Object value : listDiff.diff) {
                    String name = (String)elemPrefix + i;
                    if (value instanceof State.StateDiff) {
                        this.processStateDiff((State.StateDiff)value, name);
                    } else if (value != State.NOP) {
                        this.set.put(name, MongoDBConverter.this.valueToBson(value));
                    }
                    ++i;
                }
            }
            if (listDiff.rpush != null) {
                Object pushed = listDiff.rpush.size() == 1 ? MongoDBConverter.this.valueToBson(listDiff.rpush.get(0)) : new Document("$each", MongoDBConverter.this.listToBson(listDiff.rpush));
                this.push.put(prefix, pushed);
            }
        }

        protected void processDelta(Delta delta, String prefix) {
            Object incValue = MongoDBConverter.this.valueToBson(delta.getDeltaValue());
            this.inc.put(prefix, incValue);
        }

        protected void processValue(String name, Serializable value) {
            if (value == null) {
                this.unset.put(name, (Object)MongoDBRepository.ONE);
            } else {
                this.set.put(name, MongoDBConverter.this.valueToBson(value));
            }
        }

        protected void newUpdate() {
            this.update = new Document();
            this.updates.add(this.update);
            this.prefixKeys = new HashSet<String>();
            this.keys = new HashSet<String>();
        }

        protected void update(String op, String key, Object value) {
            this.checkForConflict(key);
            Document map = (Document)this.update.get((Object)op);
            if (map == null) {
                map = new Document();
                this.update.put(op, (Object)map);
            }
            map.put(key, value);
        }

        protected void checkForConflict(String key) {
            List<String> pKeys = this.getPrefixKeys(key);
            if (this.conflictKeys(key, pKeys)) {
                this.newUpdate();
            }
            this.prefixKeys.addAll(pKeys);
            this.keys.add(key);
        }

        protected boolean conflictKeys(String key, List<String> subkeys) {
            if (this.prefixKeys.contains(key)) {
                return true;
            }
            for (String sk : subkeys) {
                if (!this.keys.contains(sk)) continue;
                return true;
            }
            return false;
        }

        protected List<String> getPrefixKeys(String key) {
            ArrayList<String> ret = new ArrayList<String>(10);
            int i = 0;
            while ((i = key.indexOf(46, i)) > 0) {
                ret.add(key.substring(0, i++));
            }
            ret.add(key);
            return ret;
        }
    }
}

