/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.mongodb;

import com.mongodb.Block;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.Updates;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.resource.spi.ConnectionManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.nuxeo.ecm.core.api.ConcurrentUpdateException;
import org.nuxeo.ecm.core.api.CursorService;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PartialList;
import org.nuxeo.ecm.core.api.ScrollResult;
import org.nuxeo.ecm.core.api.lock.LockManager;
import org.nuxeo.ecm.core.blob.DocumentBlobManager;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.core.query.sql.model.OrderByClause;
import org.nuxeo.ecm.core.storage.State;
import org.nuxeo.ecm.core.storage.dbs.DBSExpressionEvaluator;
import org.nuxeo.ecm.core.storage.dbs.DBSRepositoryBase;
import org.nuxeo.ecm.core.storage.dbs.DBSRepositoryDescriptor;
import org.nuxeo.ecm.core.storage.dbs.DBSStateFlattener;
import org.nuxeo.ecm.core.storage.dbs.DBSTransactionState;
import org.nuxeo.ecm.core.storage.mongodb.MongoDBConverter;
import org.nuxeo.ecm.core.storage.mongodb.MongoDBRepositoryDescriptor;
import org.nuxeo.ecm.core.storage.mongodb.MongoDBRepositoryQueryBuilder;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.mongodb.MongoDBConnectionService;

public class MongoDBRepository
extends DBSRepositoryBase {
    private static final Logger log = LogManager.getLogger(MongoDBRepository.class);
    public static final String REPOSITORY_CONNECTION_PREFIX = "repository/";
    public static final Long LONG_ZERO = 0L;
    public static final Double ZERO = 0.0;
    public static final Double ONE = 1.0;
    public static final String MONGODB_ID = "_id";
    public static final String MONGODB_INC = "$inc";
    public static final String MONGODB_SET = "$set";
    public static final String MONGODB_UNSET = "$unset";
    public static final String MONGODB_PUSH = "$push";
    public static final String MONGODB_EACH = "$each";
    public static final String MONGODB_META = "$meta";
    public static final String MONGODB_TEXT_SCORE = "textScore";
    private static final String FULLTEXT_INDEX_NAME = "fulltext";
    private static final String LANGUAGE_FIELD = "__language";
    protected static final String COUNTER_NAME_UUID = "ecm:id";
    protected static final String COUNTER_FIELD = "seq";
    protected final MongoCollection<Document> coll;
    protected final MongoCollection<Document> countersColl;
    protected String idKey;
    protected boolean useCustomId;
    protected long sequenceLeft;
    protected long sequenceLastValue;
    protected long sequenceBlockSize;
    protected final MongoDBConverter converter;
    protected final CursorService<MongoCursor<Document>, Document, String> cursorService;
    protected Bson binaryKeys;
    protected static final Bson LOCK_FIELDS = Projections.include((String[])new String[]{"ecm:lockOwner", "ecm:lockCreated"});
    protected static final Bson UNSET_LOCK_UPDATE = Updates.combine((Bson[])new Bson[]{Updates.unset((String)"ecm:lockOwner"), Updates.unset((String)"ecm:lockCreated")});

    public MongoDBRepository(ConnectionManager cm, MongoDBRepositoryDescriptor descriptor) {
        super(cm, descriptor.name, (DBSRepositoryDescriptor)descriptor);
        MongoDBConnectionService mongoService = (MongoDBConnectionService)Framework.getService(MongoDBConnectionService.class);
        MongoDatabase database = mongoService.getDatabase(REPOSITORY_CONNECTION_PREFIX + descriptor.name);
        this.coll = database.getCollection(descriptor.name);
        this.countersColl = database.getCollection(descriptor.name + ".counters");
        this.idKey = Boolean.TRUE.equals(descriptor.nativeId) ? MONGODB_ID : COUNTER_NAME_UUID;
        this.useCustomId = COUNTER_NAME_UUID.equals(this.idKey);
        if (this.idType == DBSRepositoryBase.IdType.sequence) {
            Integer sbs = descriptor.sequenceBlockSize;
            this.sequenceBlockSize = sbs == null ? 1L : sbs.longValue();
            this.sequenceLeft = 0L;
        }
        this.converter = new MongoDBConverter(this.useCustomId ? null : COUNTER_NAME_UUID);
        this.cursorService = new CursorService(ob -> (String)ob.get((Object)this.converter.keyToBson(COUNTER_NAME_UUID)));
        this.initRepository();
    }

    public List<DBSRepositoryBase.IdType> getAllowedIdTypes() {
        return Arrays.asList(DBSRepositoryBase.IdType.varchar, DBSRepositoryBase.IdType.sequence);
    }

    public void shutdown() {
        super.shutdown();
        this.cursorService.clear();
    }

    protected void initRepository() {
        if (this.coll.countDocuments(Filters.eq((String)this.idKey, (Object)this.getRootId())) > 0L) {
            return;
        }
        if (this.useCustomId) {
            this.coll.createIndex(Indexes.ascending((String[])new String[]{this.idKey}));
        }
        this.coll.createIndex(Indexes.ascending((String[])new String[]{"ecm:parentId"}));
        this.coll.createIndex(Indexes.ascending((String[])new String[]{"ecm:ancestorIds"}));
        this.coll.createIndex(Indexes.ascending((String[])new String[]{"ecm:versionSeriesId"}));
        this.coll.createIndex(Indexes.ascending((String[])new String[]{"ecm:proxyTargetId"}));
        this.coll.createIndex(Indexes.ascending((String[])new String[]{"ecm:proxyVersionSeriesId"}));
        this.coll.createIndex(Indexes.ascending((String[])new String[]{"ecm:racl"}));
        this.coll.createIndex(Indexes.ascending((String[])new String[]{"ecm:parentId", "ecm:name"}));
        this.coll.createIndex(Indexes.ascending((String[])new String[]{"ecm:primaryType"}));
        this.coll.createIndex(Indexes.ascending((String[])new String[]{"ecm:lifeCycleState"}));
        this.coll.createIndex(Indexes.ascending((String[])new String[]{"ecm:isTrashed"}));
        if (!this.isFulltextDisabled()) {
            this.coll.createIndex(Indexes.ascending((String[])new String[]{"ecm:fulltextJobId"}));
        }
        this.coll.createIndex(Indexes.ascending((String[])new String[]{"ecm:acp.acl.user"}));
        this.coll.createIndex(Indexes.ascending((String[])new String[]{"ecm:acp.acl.status"}));
        this.coll.createIndex(Indexes.descending((String[])new String[]{"dc:modified"}));
        this.coll.createIndex(Indexes.ascending((String[])new String[]{"rend:renditionName"}));
        this.coll.createIndex(Indexes.ascending((String[])new String[]{"rend:sourceId"}));
        this.coll.createIndex(Indexes.ascending((String[])new String[]{"rend:sourceVersionableId"}));
        this.coll.createIndex(Indexes.ascending((String[])new String[]{"drv:subscriptions.enabled"}));
        this.coll.createIndex(Indexes.ascending((String[])new String[]{"collectionMember:collectionIds"}));
        this.coll.createIndex(Indexes.ascending((String[])new String[]{"nxtag:tags"}));
        if (!this.isFulltextSearchDisabled()) {
            Bson indexKeys = Indexes.compoundIndex((Bson[])new Bson[]{Indexes.text((String)"ecm:fulltextSimple"), Indexes.text((String)"ecm:fulltextBinary")});
            IndexOptions indexOptions = new IndexOptions().name(FULLTEXT_INDEX_NAME).languageOverride(LANGUAGE_FIELD);
            this.coll.createIndex(indexKeys, indexOptions);
        }
        if (this.idType == DBSRepositoryBase.IdType.sequence) {
            Document idCounter = new Document();
            idCounter.put(MONGODB_ID, (Object)COUNTER_NAME_UUID);
            idCounter.put(COUNTER_FIELD, (Object)LONG_ZERO);
            this.countersColl.insertOne((Object)idCounter);
        }
        this.initRoot();
    }

    protected synchronized Long getNextSequenceId() {
        if (this.sequenceLeft == 0L) {
            Bson update;
            Bson filter = Filters.eq((String)MONGODB_ID, (Object)COUNTER_NAME_UUID);
            Document idCounter = (Document)this.countersColl.findOneAndUpdate(filter, update = Updates.inc((String)COUNTER_FIELD, (Number)this.sequenceBlockSize), new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER));
            if (idCounter == null) {
                throw new NuxeoException("Repository id counter not initialized");
            }
            this.sequenceLeft = this.sequenceBlockSize;
            this.sequenceLastValue = (Long)idCounter.get((Object)COUNTER_FIELD) - this.sequenceBlockSize;
        }
        --this.sequenceLeft;
        ++this.sequenceLastValue;
        return this.sequenceLastValue;
    }

    public String generateNewId() {
        if (this.idType == DBSRepositoryBase.IdType.sequence) {
            Long id = this.getNextSequenceId();
            return id.toString();
        }
        return UUID.randomUUID().toString();
    }

    public void createState(State state) {
        Document doc = this.converter.stateToBson(state);
        log.trace("MongoDB: CREATE {}: {}", doc.get((Object)this.idKey), (Object)doc);
        this.coll.insertOne((Object)doc);
    }

    public void createStates(List<State> states) {
        List docs = states.stream().map(this.converter::stateToBson).collect(Collectors.toList());
        log.trace("MongoDB: CREATE [{}]: {}", new Supplier[]{() -> docs.stream().map(doc -> doc.get((Object)this.idKey).toString()).collect(Collectors.joining(", ")), () -> docs});
        this.coll.insertMany(docs);
    }

    public State readState(String id) {
        return this.findOne(Filters.eq((String)this.idKey, (Object)id));
    }

    public State readPartialState(String id, Collection<String> keys) {
        Document fields = new Document();
        keys.forEach(key -> fields.put(this.converter.keyToBson((String)key), (Object)ONE));
        return this.findOne(Filters.eq((String)this.idKey, (Object)id), (Bson)fields);
    }

    public List<State> readStates(List<String> ids) {
        return this.findAll(Filters.in((String)this.idKey, ids));
    }

    public void updateState(String id, State.StateDiff diff, DBSTransactionState.ChangeTokenUpdater changeTokenUpdater) {
        List<Document> updates = this.converter.diffToBson(diff);
        for (Document update : updates) {
            UpdateResult w;
            Document filter = new Document(this.idKey, (Object)id);
            if (changeTokenUpdater == null) {
                log.trace("MongoDB: UPDATE {}: {}", (Object)id, (Object)update);
            } else {
                Map conditions = changeTokenUpdater.getConditions();
                Map tokenUpdates = changeTokenUpdater.getUpdates();
                if (update.containsKey((Object)MONGODB_SET)) {
                    ((Document)update.get((Object)MONGODB_SET)).putAll(tokenUpdates);
                } else {
                    Document set = new Document();
                    set.putAll(tokenUpdates);
                    update.put(MONGODB_SET, (Object)set);
                }
                log.trace("MongoDB: UPDATE {}: IF {} THEN {}", (Object)id, (Object)conditions, (Object)update);
                filter.putAll(conditions);
            }
            if ((w = this.coll.updateMany((Bson)filter, (Bson)update)).getModifiedCount() == 1L) continue;
            log.trace("MongoDB:    -> CONCURRENT UPDATE: {}", (Object)id);
            throw new ConcurrentUpdateException(id);
        }
    }

    public void deleteStates(Set<String> ids) {
        Bson filter = Filters.in((String)this.idKey, ids);
        log.trace("MongoDB: REMOVE {}", ids);
        DeleteResult w = this.coll.deleteMany(filter);
        if (w.getDeletedCount() != (long)ids.size()) {
            Supplier[] supplierArray = new Supplier[3];
            supplierArray[0] = () -> ((DeleteResult)w).getDeletedCount();
            supplierArray[1] = ids::size;
            supplierArray[2] = () -> ids;
            log.debug("Removed {} docs for {} ids: {}", supplierArray);
        }
    }

    public State readChildState(String parentId, String name, Set<String> ignored) {
        Document filter = this.getChildQuery(parentId, name, ignored);
        return this.findOne((Bson)filter);
    }

    protected void logQuery(String id, Bson fields) {
        this.logQuery(Filters.eq((String)this.idKey, (Object)id), fields);
    }

    protected void logQuery(Bson filter, Bson fields) {
        if (fields == null) {
            log.trace("MongoDB: QUERY {}", (Object)filter);
        } else {
            log.trace("MongoDB: QUERY {} KEYS {}", (Object)filter, (Object)fields);
        }
    }

    protected void logQuery(Bson query, Bson fields, Bson orderBy, int limit, int offset) {
        if (orderBy == null) {
            log.trace("MongoDB: QUERY {} KEYS {} OFFSET {} LIMIT {}", (Object)query, (Object)fields, (Object)offset, (Object)limit);
        } else {
            log.trace("MongoDB: QUERY {} KEYS {} ORDER BY {} OFFSET {} LIMIT {}", (Object)query, (Object)fields, (Object)orderBy, (Object)offset, (Object)limit);
        }
    }

    public boolean hasChild(String parentId, String name, Set<String> ignored) {
        Document filter = this.getChildQuery(parentId, name, ignored);
        return this.exists((Bson)filter);
    }

    protected Document getChildQuery(String parentId, String name, Set<String> ignored) {
        Document filter = new Document();
        filter.put("ecm:parentId", (Object)parentId);
        filter.put("ecm:name", (Object)name);
        this.addIgnoredIds(filter, ignored);
        return filter;
    }

    protected void addIgnoredIds(Document filter, Set<String> ignored) {
        if (!ignored.isEmpty()) {
            Document notInIds = new Document("$nin", new ArrayList<String>(ignored));
            filter.put(this.idKey, (Object)notInIds);
        }
    }

    public List<State> queryKeyValue(String key, Object value, Set<String> ignored) {
        Document filter = new Document(this.converter.keyToBson(key), value);
        this.addIgnoredIds(filter, ignored);
        return this.findAll((Bson)filter);
    }

    public List<State> queryKeyValue(String key1, Object value1, String key2, Object value2, Set<String> ignored) {
        Document filter = new Document(this.converter.keyToBson(key1), value1);
        filter.put(this.converter.keyToBson(key2), value2);
        this.addIgnoredIds(filter, ignored);
        return this.findAll((Bson)filter);
    }

    public Stream<State> getDescendants(String rootId, Set<String> keys) {
        return this.getDescendants(rootId, keys, 0);
    }

    public Stream<State> getDescendants(String rootId, Set<String> keys, int limit) {
        Bson filter = Filters.eq((String)"ecm:ancestorIds", (Object)rootId);
        Document fields = new Document();
        if (this.useCustomId) {
            fields.put(MONGODB_ID, (Object)ZERO);
        }
        fields.put(this.idKey, (Object)ONE);
        keys.forEach(key -> fields.put(this.converter.keyToBson((String)key), (Object)ONE));
        return this.stream(filter, (Bson)fields, limit);
    }

    public boolean queryKeyValuePresence(String key, String value, Set<String> ignored) {
        Document filter = new Document(this.converter.keyToBson(key), (Object)value);
        this.addIgnoredIds(filter, ignored);
        return this.exists((Bson)filter);
    }

    protected boolean exists(Bson filter) {
        return this.exists(filter, (Bson)this.justPresenceField());
    }

    protected boolean exists(Bson filter, Bson projection) {
        this.logQuery(filter, projection);
        return this.coll.find(filter).projection(projection).first() != null;
    }

    protected State findOne(Bson filter) {
        return this.findOne(filter, null);
    }

    protected State findOne(Bson filter, Bson projection) {
        try (Stream<State> stream = this.stream(filter, projection);){
            State state = stream.findAny().orElse(null);
            return state;
        }
    }

    protected List<State> findAll(Bson filter) {
        try (Stream<State> stream = this.stream(filter);){
            List<State> list = stream.collect(Collectors.toList());
            return list;
        }
    }

    protected Stream<State> stream(Bson filter) {
        return this.stream(filter, null, 0);
    }

    protected Stream<State> stream(Bson filter, Bson projection) {
        return this.stream(filter, projection, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Stream<State> stream(Bson filter, Bson projection, int limit) {
        if (filter == null) {
            filter = new Document();
        }
        this.logQuery(filter, projection);
        boolean completedAbruptly = true;
        MongoCursor cursor = this.coll.find(filter).limit(limit).projection(projection).iterator();
        try {
            HashSet seen = new HashSet();
            Stream<State> stream = ((Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(cursor, 0), false).onClose(() -> ((MongoCursor)cursor).close())).filter(doc -> seen.add(doc.getString((Object)this.idKey))).map(this.converter::bsonToState);
            completedAbruptly = false;
            Stream<State> stream2 = stream;
            return stream2;
        }
        finally {
            if (completedAbruptly) {
                cursor.close();
            }
        }
    }

    protected Document justPresenceField() {
        return new Document(MONGODB_ID, (Object)ONE);
    }

    public PartialList<Map<String, Serializable>> queryAndFetch(DBSExpressionEvaluator evaluator, OrderByClause orderByClause, boolean distinctDocuments, int limit, int offset, int countUpTo) {
        long totalSize;
        ArrayList<Map> projections;
        boolean manualProjection;
        MongoDBRepositoryQueryBuilder builder = new MongoDBRepositoryQueryBuilder(this, evaluator.getExpression(), evaluator.getSelectClause(), orderByClause, evaluator.pathResolver, evaluator.fulltextSearchDisabled);
        builder.walk();
        if (builder.hasFulltext && this.isFulltextSearchDisabled()) {
            throw new QueryParseException("Fulltext search disabled by configuration");
        }
        Document filter = builder.getQuery();
        this.addPrincipals(filter, evaluator.principals);
        Document orderBy = builder.getOrderBy();
        Document keys = builder.getProjection();
        boolean bl = manualProjection = !distinctDocuments && builder.hasProjectionWildcard();
        if (manualProjection) {
            keys = null;
            evaluator.parse();
        }
        this.logQuery((Bson)filter, (Bson)keys, (Bson)orderBy, limit, offset);
        try (MongoCursor cursor = this.coll.find((Bson)filter).projection((Bson)keys).skip(offset).limit(limit).sort((Bson)orderBy).iterator();){
            projections = new ArrayList<Map>();
            DBSStateFlattener flattener = new DBSStateFlattener(builder.propertyKeys);
            Iterable docs = () -> cursor;
            for (Document doc : docs) {
                State state = this.converter.bsonToState(doc);
                if (manualProjection) {
                    projections.addAll(evaluator.matches(state));
                    continue;
                }
                projections.add(flattener.flatten(state));
            }
        }
        if (countUpTo == -1) {
            totalSize = limit == 0 ? (long)projections.size() : (manualProjection ? -1L : this.coll.countDocuments((Bson)filter));
        } else if (countUpTo == 0) {
            totalSize = -1L;
        } else {
            totalSize = limit == 0 ? (long)projections.size() : (manualProjection ? -1L : this.coll.countDocuments((Bson)filter, new CountOptions().limit(countUpTo + 1)));
            if (totalSize > (long)countUpTo) {
                totalSize = -2L;
            }
        }
        if (!projections.isEmpty()) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = projections::size;
            log.trace("MongoDB:    -> {}", supplierArray);
        }
        return new PartialList(projections, totalSize);
    }

    public ScrollResult<String> scroll(DBSExpressionEvaluator evaluator, int batchSize, int keepAliveSeconds) {
        this.cursorService.checkForTimedOutScroll();
        MongoDBRepositoryQueryBuilder builder = new MongoDBRepositoryQueryBuilder(this, evaluator.getExpression(), evaluator.getSelectClause(), null, evaluator.pathResolver, evaluator.fulltextSearchDisabled);
        builder.walk();
        if (builder.hasFulltext && this.isFulltextSearchDisabled()) {
            throw new QueryParseException("Fulltext search disabled by configuration");
        }
        Document filter = builder.getQuery();
        this.addPrincipals(filter, evaluator.principals);
        Document keys = builder.getProjection();
        this.logQuery((Bson)filter, (Bson)keys, null, 0, 0);
        MongoCursor cursor = this.coll.find((Bson)filter).projection((Bson)keys).batchSize(batchSize).iterator();
        String scrollId = this.cursorService.registerCursor((Object)cursor, batchSize, keepAliveSeconds);
        return this.scroll(scrollId);
    }

    public ScrollResult<String> scroll(String scrollId) {
        return this.cursorService.scroll(scrollId);
    }

    protected void addPrincipals(Document query, Set<String> principals) {
        if (principals != null) {
            Document inPrincipals = new Document("$in", new ArrayList<String>(principals));
            query.put("ecm:racl", (Object)inPrincipals);
        }
    }

    protected void initBlobsPaths() {
        MongoDBBlobFinder finder = new MongoDBBlobFinder();
        finder.visit();
        this.binaryKeys = Projections.fields(finder.binaryKeys);
    }

    public void markReferencedBinaries() {
        DocumentBlobManager blobManager = (DocumentBlobManager)Framework.getService(DocumentBlobManager.class);
        this.logQuery((Bson)new Document(), this.binaryKeys);
        Block block = doc -> this.markReferencedBinaries((Document)doc, blobManager);
        this.coll.find().projection(this.binaryKeys).forEach(block);
    }

    protected void markReferencedBinaries(Document ob, DocumentBlobManager blobManager) {
        for (Object value : ob.values()) {
            if (value instanceof List) {
                List list = (List)value;
                for (Object v : list) {
                    if (v instanceof Document) {
                        this.markReferencedBinaries((Document)v, blobManager);
                        continue;
                    }
                    this.markReferencedBinary(v, blobManager);
                }
                continue;
            }
            if (value instanceof Object[]) {
                for (Object v : (Object[])value) {
                    this.markReferencedBinary(v, blobManager);
                }
                continue;
            }
            if (value instanceof Document) {
                this.markReferencedBinaries((Document)value, blobManager);
                continue;
            }
            this.markReferencedBinary(value, blobManager);
        }
    }

    protected void markReferencedBinary(Object value, DocumentBlobManager blobManager) {
        if (!(value instanceof String)) {
            return;
        }
        String key = (String)value;
        blobManager.markReferencedBinary(key, this.repositoryName);
    }

    public Lock getLock(String id) {
        this.logQuery(id, LOCK_FIELDS);
        Document res = (Document)this.coll.find(Filters.eq((String)this.idKey, (Object)id)).projection(LOCK_FIELDS).first();
        if (res == null) {
            throw new DocumentNotFoundException(id);
        }
        String owner = res.getString((Object)"ecm:lockOwner");
        if (owner == null) {
            return null;
        }
        Calendar created = (Calendar)this.converter.scalarToSerializable(res.get((Object)"ecm:lockCreated"));
        return new Lock(owner, created);
    }

    public Lock setLock(String id, Lock lock) {
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)this.idKey, (Object)id), Filters.exists((String)"ecm:lockOwner", (boolean)false)});
        Bson setLock = Updates.combine((Bson[])new Bson[]{Updates.set((String)"ecm:lockOwner", (Object)lock.getOwner()), Updates.set((String)"ecm:lockCreated", (Object)this.converter.serializableToBson(lock.getCreated()))});
        log.trace("MongoDB: FINDANDMODIFY {} UPDATE {}", (Object)filter, (Object)setLock);
        Document res = (Document)this.coll.findOneAndUpdate(filter, setLock);
        if (res != null) {
            return null;
        }
        this.logQuery(id, LOCK_FIELDS);
        Document old = (Document)this.coll.find(Filters.eq((String)this.idKey, (Object)id)).projection(LOCK_FIELDS).first();
        if (old == null) {
            throw new DocumentNotFoundException(id);
        }
        String oldOwner = (String)old.get((Object)"ecm:lockOwner");
        Calendar oldCreated = (Calendar)this.converter.scalarToSerializable(old.get((Object)"ecm:lockCreated"));
        if (oldOwner != null) {
            return new Lock(oldOwner, oldCreated);
        }
        throw new ConcurrentUpdateException("Lock " + id);
    }

    public Lock removeLock(String id, String owner) {
        Document filter = new Document(this.idKey, (Object)id);
        if (owner != null) {
            List<String> ownerOrNull = Arrays.asList(owner, null);
            filter.put("ecm:lockOwner", (Object)new Document("$in", ownerOrNull));
        }
        log.trace("MongoDB: FINDANDMODIFY {} UPDATE {}", (Object)filter, (Object)UNSET_LOCK_UPDATE);
        Document old = (Document)this.coll.findOneAndUpdate((Bson)filter, UNSET_LOCK_UPDATE);
        if (old != null) {
            String oldOwner = (String)old.get((Object)"ecm:lockOwner");
            if (oldOwner == null) {
                return null;
            }
            Calendar oldCreated = (Calendar)this.converter.scalarToSerializable(old.get((Object)"ecm:lockCreated"));
            return new Lock(oldOwner, oldCreated);
        }
        this.logQuery(id, LOCK_FIELDS);
        old = (Document)this.coll.find(Filters.eq((String)this.idKey, (Object)id)).projection(LOCK_FIELDS).first();
        if (old == null) {
            throw new DocumentNotFoundException(id);
        }
        String oldOwner = (String)old.get((Object)"ecm:lockOwner");
        Calendar oldCreated = (Calendar)this.converter.scalarToSerializable(old.get((Object)"ecm:lockCreated"));
        if (oldOwner != null) {
            if (!LockManager.canLockBeRemoved((String)oldOwner, (String)owner)) {
                return new Lock(oldOwner, oldCreated, true);
            }
            throw new ConcurrentUpdateException("Unlock " + id);
        }
        throw new ConcurrentUpdateException("Unlock " + id);
    }

    public void closeLockManager() {
    }

    public void clearLockManagerCaches() {
    }

    protected static class MongoDBBlobFinder
    extends DBSRepositoryBase.BlobFinder {
        protected List<Bson> binaryKeys = new ArrayList<Bson>(Collections.singleton(Projections.excludeId()));

        protected MongoDBBlobFinder() {
        }

        protected void recordBlobPath() {
            this.path.addLast("data");
            this.binaryKeys.add(Projections.include((String[])new String[]{StringUtils.join((Iterable)this.path, (String)".")}));
            this.path.removeLast();
        }
    }
}

