/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.query.sql.model;

import java.sql.Date;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.nuxeo.common.utils.DateUtils;
import org.nuxeo.ecm.core.query.sql.model.IVisitor;
import org.nuxeo.ecm.core.query.sql.model.Literal;

public class DateLiteral
extends Literal {
    private static final long serialVersionUID = 279219479611055690L;
    public final ZonedDateTime value;
    public final boolean onlyDate;

    public DateLiteral(ZonedDateTime value) {
        this.value = value;
        this.onlyDate = false;
    }

    public DateLiteral(String value, boolean onlyDate) {
        this.onlyDate = onlyDate;
        this.value = DateUtils.parseISODateTime((String)value);
    }

    public Calendar toCalendar() {
        return GregorianCalendar.from(this.value);
    }

    public Date toSqlDate() {
        return new Date(this.value.toInstant().toEpochMilli());
    }

    public String toString() {
        String s = DateUtils.formatISODateTime((ZonedDateTime)this.value, (boolean)this.onlyDate);
        if (this.onlyDate) {
            return "DATE '" + s + "'";
        }
        return "TIMESTAMP '" + s + "'";
    }

    @Override
    public String asString() {
        return DateUtils.formatISODateTime((ZonedDateTime)this.value, (boolean)this.onlyDate);
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitDateLiteral(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DateLiteral) {
            return this.value.equals(((DateLiteral)obj).value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Deprecated
    public static String dateTime(DateLiteral date) {
        return DateUtils.formatISODateTime((ZonedDateTime)date.value);
    }

    @Deprecated
    public static String date(DateLiteral date) {
        return DateUtils.formatISODateTime((ZonedDateTime)date.value);
    }
}

