/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.query.sql.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.query.sql.model.EsIdentifierList;
import org.nuxeo.ecm.core.query.sql.model.IVisitor;
import org.nuxeo.ecm.core.query.sql.model.Operand;

public class EsHint
implements Operand {
    private static final long serialVersionUID = 4590329982296853715L;
    public final String index;
    public final String analyzer;
    public final String operator;

    public EsHint(EsIdentifierList index, String analyzer, String operator) {
        this.index = index == null ? null : index.toString();
        this.analyzer = analyzer;
        this.operator = operator;
    }

    @Override
    public void accept(IVisitor visitor) {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("/*+ES: ");
        if (this.index != null) {
            sb.append(String.format("INDEX(%s) ", this.index));
        }
        if (this.analyzer != null) {
            sb.append(String.format("ANALYZER(%s) ", this.analyzer));
        }
        if (this.operator != null) {
            sb.append(String.format("OPERATOR(%s) ", this.operator));
        }
        sb.append("*/");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EsHint)) {
            return false;
        }
        return this.equals((EsHint)obj);
    }

    private boolean equals(EsHint other) {
        return StringUtils.equals((CharSequence)this.index, (CharSequence)other.index) && StringUtils.equals((CharSequence)this.analyzer, (CharSequence)other.analyzer) && StringUtils.equals((CharSequence)this.operator, (CharSequence)other.operator);
    }

    public List<FieldHint> getIndex() {
        if (this.index == null) {
            return Collections.emptyList();
        }
        String[] fields = this.index.split(",");
        return Arrays.stream(fields).map(FieldHint::new).collect(Collectors.toList());
    }

    public String[] getIndexFieldNames() {
        return (String[])this.getIndex().stream().map(FieldHint::getField).toArray(String[]::new);
    }

    public static class FieldHint {
        public static final float DEFAULT_BOOST = 1.0f;
        protected final String field;
        protected final float boost;

        public FieldHint(String indexField) {
            String[] parsed = indexField.split("\\^");
            this.field = parsed[0];
            this.boost = parsed.length > 1 ? Float.parseFloat(parsed[1]) : 1.0f;
        }

        public FieldHint(String field, Float boost) {
            this.field = field;
            this.boost = boost == null ? 1.0f : boost.floatValue();
        }

        public String getField() {
            return this.field;
        }

        public float getBoost() {
            return this.boost;
        }
    }
}

