/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.query.sql.model;

import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.nuxeo.common.utils.DateUtils;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.core.query.sql.model.BooleanLiteral;
import org.nuxeo.ecm.core.query.sql.model.DateLiteral;
import org.nuxeo.ecm.core.query.sql.model.DoubleLiteral;
import org.nuxeo.ecm.core.query.sql.model.IntegerLiteral;
import org.nuxeo.ecm.core.query.sql.model.Literal;
import org.nuxeo.ecm.core.query.sql.model.LiteralList;
import org.nuxeo.ecm.core.query.sql.model.Operand;
import org.nuxeo.ecm.core.query.sql.model.StringLiteral;

public class Literals {
    public static Object valueOf(Operand operand) {
        if (operand instanceof LiteralList) {
            return Literals.valueOf((LiteralList)operand);
        }
        if (operand instanceof Literal) {
            return Literals.valueOf((Literal)operand);
        }
        throw new QueryParseException("Operand is not a Literal neither a LiteralList, op=" + operand);
    }

    public static List<Object> valueOf(LiteralList litList) {
        return litList.stream().map(Literals::valueOf).collect(Collectors.toList());
    }

    public static Object valueOf(Literal lit) {
        if (lit instanceof BooleanLiteral) {
            return Literals.valueOf((BooleanLiteral)lit);
        }
        if (lit instanceof DateLiteral) {
            return Literals.valueOf((DateLiteral)lit);
        }
        if (lit instanceof DoubleLiteral) {
            return Literals.valueOf((DoubleLiteral)lit);
        }
        if (lit instanceof IntegerLiteral) {
            return Literals.valueOf((IntegerLiteral)lit);
        }
        if (lit instanceof StringLiteral) {
            return Literals.valueOf((StringLiteral)lit);
        }
        throw new QueryParseException("Unknown literal: " + lit);
    }

    public static Object valueOf(BooleanLiteral lit) {
        return lit.value;
    }

    public static ZonedDateTime valueOf(DateLiteral lit) {
        return lit.value;
    }

    public static Double valueOf(DoubleLiteral lit) {
        return lit.value;
    }

    public static Long valueOf(IntegerLiteral lit) {
        return lit.value;
    }

    public static String valueOf(StringLiteral lit) {
        return lit.value;
    }

    public static Literal toLiteral(Object value) {
        if (value instanceof Boolean) {
            return new BooleanLiteral((Boolean)value);
        }
        if (value instanceof Calendar) {
            return new DateLiteral(DateUtils.toZonedDateTime((Calendar)((Calendar)value)));
        }
        if (value instanceof Date) {
            return new DateLiteral(DateUtils.toZonedDateTime((Date)((Date)value)));
        }
        if (value instanceof ZonedDateTime) {
            return new DateLiteral((ZonedDateTime)value);
        }
        if (value instanceof Temporal) {
            return new DateLiteral(ZonedDateTime.from((Temporal)value));
        }
        if (value instanceof Double) {
            return new DoubleLiteral((Double)value);
        }
        if (value instanceof Float) {
            return new DoubleLiteral((Float)value);
        }
        if (value instanceof Integer) {
            return new IntegerLiteral((Integer)value);
        }
        if (value instanceof Long) {
            return new IntegerLiteral((Long)value);
        }
        if (value instanceof String) {
            return new StringLiteral((String)value);
        }
        throw new NuxeoException("Unknown type to convert to literal, value=" + value);
    }
}

