/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.query.sql.model;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.nuxeo.ecm.core.query.sql.model.LiteralList;
import org.nuxeo.ecm.core.query.sql.model.Literals;
import org.nuxeo.ecm.core.query.sql.model.Operator;
import org.nuxeo.ecm.core.query.sql.model.Predicate;
import org.nuxeo.ecm.core.query.sql.model.Reference;

public class Predicates {
    private Predicates() {
    }

    public static Predicate and(Predicate left, Predicate right) {
        return new Predicate(left, Operator.AND, right);
    }

    public static Predicate or(Predicate left, Predicate right) {
        return new Predicate(left, Operator.OR, right);
    }

    public static Predicate not(Predicate predicate) {
        return new Predicate(predicate, Operator.NOT, null);
    }

    public static Predicate eq(String name, Object value) {
        return Predicates.createPredicate(name, Operator.EQ, value);
    }

    public static Predicate noteq(String name, Object value) {
        return Predicates.createPredicate(name, Operator.NOTEQ, value);
    }

    public static Predicate lt(String name, Object value) {
        return Predicates.createPredicate(name, Operator.LT, value);
    }

    public static Predicate lte(String name, Object value) {
        return Predicates.createPredicate(name, Operator.LTEQ, value);
    }

    public static Predicate gte(String name, Object value) {
        return Predicates.createPredicate(name, Operator.GTEQ, value);
    }

    public static Predicate gt(String name, Object value) {
        return Predicates.createPredicate(name, Operator.GT, value);
    }

    public static Predicate startsWith(String name, Object value) {
        return Predicates.createPredicate(name, Operator.STARTSWITH, value);
    }

    public static Predicate like(String name, Object value) {
        return Predicates.createPredicate(name, Operator.LIKE, value);
    }

    public static Predicate notlike(String name, Object value) {
        return Predicates.createPredicate(name, Operator.NOTLIKE, value);
    }

    public static Predicate ilike(String name, Object value) {
        return Predicates.createPredicate(name, Operator.ILIKE, value);
    }

    public static Predicate notilike(String name, Object value) {
        return Predicates.createPredicate(name, Operator.NOTILIKE, value);
    }

    public static Predicate in(String name, Iterable<?> values) {
        return Predicates.createPredicate(name, Operator.IN, StreamSupport.stream(values.spliterator(), false));
    }

    public static <T> Predicate in(String name, T value, T ... values) {
        return Predicates.createPredicate(name, Operator.IN, Stream.concat(Stream.of(value), Stream.of(values)));
    }

    public static Predicate in(String name, Object[] values) {
        return Predicates.createPredicate(name, Operator.IN, Stream.of(values));
    }

    public static Predicate notin(String name, Iterable<?> values) {
        return Predicates.createPredicate(name, Operator.NOTIN, StreamSupport.stream(values.spliterator(), false));
    }

    public static <T> Predicate notin(String name, T value, T ... values) {
        return Predicates.createPredicate(name, Operator.NOTIN, Stream.concat(Stream.of(value), Stream.of(values)));
    }

    public static Predicate notin(String name, Object[] values) {
        return Predicates.createPredicate(name, Operator.NOTIN, Stream.of(values));
    }

    public static Predicate between(String name, Object min, Object max) {
        LiteralList range = new LiteralList();
        range.add(Literals.toLiteral(min));
        range.add(Literals.toLiteral(max));
        return new Predicate(new Reference(name), Operator.BETWEEN, range);
    }

    public static Predicate notbetween(String name, Object min, Object max) {
        LiteralList range = new LiteralList();
        range.add(Literals.toLiteral(min));
        range.add(Literals.toLiteral(max));
        return new Predicate(new Reference(name), Operator.NOTBETWEEN, range);
    }

    public static Predicate isnull(String name) {
        return new Predicate(new Reference(name), Operator.ISNULL, null);
    }

    public static Predicate isnotnull(String name) {
        return new Predicate(new Reference(name), Operator.ISNOTNULL, null);
    }

    private static Predicate createPredicate(String name, Operator operator, Object value) {
        return new Predicate(new Reference(name), operator, Literals.toLiteral(value));
    }

    private static Predicate createPredicate(String name, Operator operator, Stream<?> values) {
        return new Predicate(new Reference(name), operator, values.map(Literals::toLiteral).collect(Collectors.toCollection(LiteralList::new)));
    }
}

