/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.query.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.nuxeo.ecm.platform.query.api.PageSelection;

public class PageSelections<T> {
    protected String name;
    protected boolean selected;
    protected List<PageSelection<T>> entries;

    public PageSelections() {
    }

    public PageSelections(Collection<? extends PageSelection<T>> c) {
        if (c != null) {
            this.entries = new ArrayList<PageSelection<T>>(c);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        if (this.entries != null) {
            for (PageSelection<T> item : this.entries) {
                item.setSelected(selected);
            }
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public List<PageSelection<T>> getEntries() {
        return this.entries;
    }

    public void setEntries(List<PageSelection<T>> entries) {
        this.entries = entries;
    }

    public void add(PageSelection<T> entry) {
        if (this.entries == null) {
            this.entries = new ArrayList<PageSelection<T>>();
        }
        this.entries.add(entry);
    }

    public int getSize() {
        if (this.entries == null) {
            return 0;
        }
        return this.entries.size();
    }

    @Deprecated
    public int getRowCount() {
        return this.getSize();
    }

    @Deprecated
    public List<PageSelection<T>> getRows() {
        return this.getEntries();
    }

    public boolean isEmpty() {
        return this.getSize() == 0;
    }
}

