/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common.exceptionhandling;

import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletException;
import org.nuxeo.ecm.core.api.DocumentSecurityException;

public class ExceptionHelper {
    protected static final List<String> ERROR_MESSAGES = Arrays.asList("java.lang.SecurityException", DocumentSecurityException.class.getName(), SecurityException.class.getName());

    private ExceptionHelper() {
    }

    public static Throwable unwrapException(Throwable t) {
        Throwable cause = null;
        if (t instanceof ServletException) {
            cause = ((ServletException)t).getRootCause();
        } else if (t instanceof Exception) {
            cause = t.getCause();
        }
        if (cause == null) {
            return t;
        }
        return ExceptionHelper.unwrapException(cause);
    }

    public static boolean isSecurityError(Throwable t) {
        if (t == null) {
            return false;
        }
        if (t instanceof DocumentSecurityException || t.getCause() instanceof DocumentSecurityException || t.getCause() instanceof SecurityException) {
            return true;
        }
        if (t.getMessage() != null) {
            String message = t.getMessage();
            for (String errorMessage : ERROR_MESSAGES) {
                if (!message.contains(errorMessage)) continue;
                return true;
            }
        }
        return false;
    }
}

