/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.computation.log;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.codec.NoCodec;
import org.nuxeo.lib.stream.computation.ComputationMetadataMapping;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.lib.stream.computation.Settings;
import org.nuxeo.lib.stream.computation.StreamProcessor;
import org.nuxeo.lib.stream.computation.Topology;
import org.nuxeo.lib.stream.computation.Watermark;
import org.nuxeo.lib.stream.computation.log.ComputationPool;
import org.nuxeo.lib.stream.computation.log.LogStreamManager;
import org.nuxeo.lib.stream.log.Latency;
import org.nuxeo.lib.stream.log.LogManager;
import org.nuxeo.lib.stream.log.LogPartition;
import org.nuxeo.lib.stream.log.kafka.KafkaUtils;

public class LogStreamProcessor
implements StreamProcessor {
    private static final Log log = LogFactory.getLog(LogStreamProcessor.class);
    protected final LogManager manager;
    protected Topology topology;
    protected Settings settings;
    protected List<ComputationPool> pools;
    protected LogStreamManager streamManager;
    protected final boolean needRegister;

    @Deprecated
    public LogStreamProcessor(LogManager manager) {
        this.needRegister = true;
        this.manager = manager;
        this.streamManager = new LogStreamManager(manager);
    }

    public LogStreamProcessor(LogStreamManager streamManager) {
        this.needRegister = false;
        this.streamManager = streamManager;
        this.manager = streamManager.getLogManager();
    }

    @Override
    public StreamProcessor init(Topology topology, Settings settings) {
        log.debug((Object)"Initializing ...");
        this.topology = topology;
        this.settings = settings;
        if (this.needRegister) {
            this.streamManager.register("_", topology, settings);
        }
        return this;
    }

    @Override
    public void start() {
        log.debug((Object)"Starting ...");
        this.pools = this.initPools();
        Objects.requireNonNull(this.pools);
        this.pools.forEach(ComputationPool::start);
    }

    @Override
    public boolean waitForAssignments(Duration timeout) throws InterruptedException {
        for (ComputationPool pool : this.pools) {
            if (pool.waitForAssignments(timeout)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isTerminated() {
        return this.pools.stream().allMatch(ComputationPool::isTerminated);
    }

    @Override
    public boolean stop(Duration timeout) {
        log.debug((Object)"Stopping ...");
        if (this.pools == null) {
            return true;
        }
        long failures = this.pools.parallelStream().filter(comp -> !comp.stop(timeout)).count();
        log.debug((Object)String.format("Stopped %d failure", failures));
        return failures == 0L;
    }

    @Override
    public boolean drainAndStop(Duration timeout) {
        log.debug((Object)"Drain and stop");
        if (this.pools == null) {
            return true;
        }
        long failures = this.pools.stream().filter(comp -> !comp.drainAndStop(timeout)).count();
        log.debug((Object)String.format("Drained and stopped %d failure", failures));
        return failures == 0L;
    }

    @Override
    public void shutdown() {
        log.debug((Object)"Shutdown ...");
        if (this.pools == null) {
            return;
        }
        this.pools.parallelStream().forEach(ComputationPool::shutdown);
        log.debug((Object)"Shutdown done");
    }

    @Override
    public long getLowWatermark() {
        HashMap watermarks = new HashMap(this.pools.size());
        Set<String> roots = this.topology.getRoots();
        HashMap<String, Long> watermarkTrees = new HashMap<String, Long>(roots.size());
        this.pools.forEach(pool -> watermarks.put(pool.getComputationName(), pool.getLowWatermark()));
        for (String root : roots) {
            watermarkTrees.put(root, this.topology.getDescendantComputationNames(root).stream().mapToLong(watermarks::get).min().orElse(0L));
        }
        long ret = watermarkTrees.values().stream().filter(wm -> wm > 1L).mapToLong(Long::valueOf).min().orElse(0L);
        if (log.isTraceEnabled()) {
            log.trace((Object)("lowWatermark: " + ret));
            watermarkTrees.forEach((k, v) -> log.trace((Object)("tree " + k + ": " + v)));
        }
        return ret;
    }

    @Override
    public Latency getLatency(String computationName) {
        Set<String> ancestorsComputations = this.topology.getAncestorComputationNames(computationName);
        ancestorsComputations.add(computationName);
        ArrayList<Latency> latencies = new ArrayList<Latency>();
        ancestorsComputations.forEach(comp -> this.topology.getMetadata((String)comp).inputStreams().forEach(stream -> latencies.add(this.manager.getLatency((String)stream, (String)comp, this.settings.getCodec((String)comp), rec -> Watermark.ofValue(rec.getWatermark()).getTimestamp(), Record::getKey))));
        return Latency.of(latencies);
    }

    @Override
    public long getLowWatermark(String computationName) {
        Objects.requireNonNull(computationName);
        HashMap watermarks = new HashMap(this.pools.size());
        this.pools.forEach(pool -> watermarks.put(pool.getComputationName(), pool.getLowWatermark()));
        long ret = this.topology.getAncestorComputationNames(computationName).stream().mapToLong(watermarks::get).min().orElse(0L);
        ret = Math.min(ret, (Long)watermarks.get(computationName));
        return ret;
    }

    @Override
    public boolean isDone(long timestamp) {
        return Watermark.ofValue(this.getLowWatermark()).isDone(timestamp);
    }

    protected List<ComputationPool> initPools() {
        log.debug((Object)"Initializing pools");
        return this.topology.metadataList().stream().map(meta -> new ComputationPool(this.topology.getSupplier(meta.name()), (ComputationMetadataMapping)meta, this.getDefaultAssignments((ComputationMetadataMapping)meta), this.streamManager, this.settings.getPolicy(meta.name()))).collect(Collectors.toList());
    }

    protected Codec<Record> getCodecForStreams(String name, Set<String> streams) {
        Codec codec = null;
        HashSet<String> codecNames = new HashSet<String>();
        for (String stream : streams) {
            codec = this.settings.getCodec(stream);
            codecNames.add(codec == null ? "none" : codec.getName());
        }
        if (codecNames.size() > 1) {
            throw new IllegalArgumentException(String.format("Different codecs for computation %s: %s", name, Arrays.toString(codecNames.toArray())));
        }
        if (codec == null) {
            codec = NoCodec.NO_CODEC;
        }
        return codec;
    }

    protected List<List<LogPartition>> getDefaultAssignments(ComputationMetadataMapping meta) {
        int threads = this.settings.getConcurrency(meta.name());
        HashMap<String, Integer> streams = new HashMap<String, Integer>();
        meta.inputStreams().forEach(streamName -> streams.put((String)streamName, this.settings.getPartitions((String)streamName)));
        return KafkaUtils.roundRobinAssignments(threads, streams);
    }
}

