/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.tools.command;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.nuxeo.lib.stream.computation.Settings;
import org.nuxeo.lib.stream.computation.StreamProcessor;
import org.nuxeo.lib.stream.computation.Topology;
import org.nuxeo.lib.stream.computation.log.LogStreamManager;
import org.nuxeo.lib.stream.log.LogManager;
import org.nuxeo.lib.stream.tools.command.Command;
import org.nuxeo.lib.stream.tools.command.LatencyTrackerComputation;

public class TrackerCommand
extends Command {
    public static final String COMPUTATION_NAME = "LatencyTracker";
    public static final String INPUT_STREAM = "log_null";
    public static final String INTERNAL_LOG_PREFIX = "_";
    protected static final String NAME = "tracker";
    protected static final String DEFAULT_INTERVAL = "60";
    protected static final String DEFAULT_COUNT = "-1";
    protected static final String ALL_LOGS = "all";
    protected static final String DEFAULT_LATENCIES_LOG = "_consumer_latencies";
    protected boolean verbose = false;
    protected String output;
    protected List<String> logNames;
    protected int interval;
    protected int count;
    protected Topology topology;
    protected StreamProcessor processor;
    protected String codec;

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void updateOptions(Options options) {
        options.addOption(Option.builder((String)"l").longOpt("log-name").desc("Track consumers latency for this LOG, must be a computation Record, can be a comma separated list of log names or ALL").required().hasArg().argName("LOG_NAME").build());
        options.addOption(Option.builder((String)"o").longOpt("log-output").desc("Log name of the output").hasArg().argName("LOG_OUTPUT").build());
        options.addOption(Option.builder((String)"i").longOpt("interval").desc("send latency spaced at the specified interval in seconds").hasArg().argName("INTERVAL").build());
        options.addOption(Option.builder((String)"c").longOpt("count").desc("number of time to send the latency information").hasArg().argName("COUNT").build());
        options.addOption(Option.builder().longOpt("codec").desc("Codec used to read record, can be: java, avro, avroBinary, avroJson").hasArg().argName("CODEC").build());
        options.addOption(Option.builder().longOpt("verbose").build());
    }

    @Override
    public boolean run(LogManager manager, CommandLine cmd) {
        this.logNames = this.getLogNames(manager, cmd.getOptionValue("log-name"));
        this.output = cmd.getOptionValue("log-output", DEFAULT_LATENCIES_LOG);
        this.codec = cmd.getOptionValue("codec");
        this.verbose = cmd.hasOption("verbose");
        this.interval = Integer.parseInt(cmd.getOptionValue("interval", DEFAULT_INTERVAL));
        this.count = Integer.parseInt(cmd.getOptionValue("count", DEFAULT_COUNT));
        this.initTopology(manager);
        return this.runProcessor(manager);
    }

    protected List<String> getLogNames(LogManager manager, String names) {
        if (ALL_LOGS.equalsIgnoreCase(names)) {
            return manager.listAll().stream().filter(name -> !name.startsWith(INTERNAL_LOG_PREFIX)).collect(Collectors.toList());
        }
        List<String> ret = Arrays.asList(names.split(","));
        for (String name2 : ret) {
            if (manager.exists(name2)) continue;
            throw new IllegalArgumentException("Unknown log name: " + name2);
        }
        return ret;
    }

    protected void initTopology(LogManager manager) {
        this.topology = Topology.builder().addComputation(() -> new LatencyTrackerComputation(manager, this.logNames, COMPUTATION_NAME, this.interval, this.count, this.verbose, this.getRecordCodec(this.codec)), Arrays.asList("i1:log_null", "o1:" + this.output)).build();
    }

    protected boolean runProcessor(LogManager manager) {
        LogStreamManager streamManager = new LogStreamManager(manager);
        Settings settings = new Settings(1, 1, this.getRecordCodec(this.codec));
        this.processor = streamManager.registerAndCreateProcessor(NAME, this.topology, settings);
        this.processor.start();
        while (!this.processor.isTerminated()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.processor.shutdown();
                return false;
            }
        }
        return true;
    }
}

