/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema;

import javax.naming.NamingException;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.Normalizer;

public class NameAndOptionalUIDNormalizer
implements Normalizer {
    private static final long serialVersionUID = 1L;
    private AttributeTypeRegistry attrRegistry;

    public NameAndOptionalUIDNormalizer(AttributeTypeRegistry attrRegistry) {
        this.attrRegistry = attrRegistry;
    }

    public NameAndOptionalUIDNormalizer() {
    }

    public void setRegistries(Registries registries) {
        this.attrRegistry = registries.getAttributeTypeRegistry();
    }

    public Object normalize(Object value) throws NamingException {
        if (value instanceof String) {
            String nameAndUid = (String)value;
            if (nameAndUid.length() == 0) {
                return false;
            }
            int sharpPos = nameAndUid.lastIndexOf(35);
            if (sharpPos != -1) {
                if (nameAndUid.indexOf(35) != sharpPos) {
                    return false;
                }
                String uid = nameAndUid.substring(sharpPos + 1);
                if (sharpPos > 0) {
                    LdapDN dn = new LdapDN(nameAndUid.substring(0, sharpPos));
                    dn.normalize(this.attrRegistry.getNormalizerMapping());
                    return dn.getNormName() + '#' + uid;
                }
                throw new IllegalStateException("I do not know how to handle NameAndOptionalUID normalization with objects of class: " + (value == null ? null : value.getClass()));
            }
            return new LdapDN(nameAndUid).getNormName();
        }
        throw new IllegalStateException("I do not know how to handle NameAndOptionalUID normalization with objects of class: " + (value == null ? null : value.getClass()));
    }
}

