/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema.registries;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.directory.server.schema.registries.ComparatorRegistry;
import org.apache.directory.shared.ldap.schema.syntax.ComparatorDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultComparatorRegistry
implements ComparatorRegistry {
    private static final Logger log = LoggerFactory.getLogger(DefaultComparatorRegistry.class);
    private final Map<String, Comparator> byOid = new HashMap<String, Comparator>();
    private final Map<String, ComparatorDescription> oidToDescription = new HashMap<String, ComparatorDescription>();

    @Override
    public void register(ComparatorDescription description, Comparator comparator) throws NamingException {
        if (this.byOid.containsKey(description.getNumericOid())) {
            NamingException e = new NamingException("Comparator with OID " + description.getNumericOid() + " already registered!");
            throw e;
        }
        this.oidToDescription.put(description.getNumericOid(), description);
        this.byOid.put(description.getNumericOid(), comparator);
        if (log.isDebugEnabled()) {
            log.debug("registed comparator with OID: " + description.getNumericOid());
        }
    }

    private static String getSchema(ComparatorDescription desc) {
        List values = (List)desc.getExtensions().get("X-SCHEMA");
        if (values == null || values.size() == 0) {
            return "other";
        }
        return (String)((List)desc.getExtensions().get("X-SCHEMA")).get(0);
    }

    @Override
    public Comparator lookup(String oid) throws NamingException {
        if (this.byOid.containsKey(oid)) {
            Comparator c = this.byOid.get(oid);
            if (log.isDebugEnabled()) {
                log.debug("looked up comparator with OID: " + oid);
            }
            return c;
        }
        NamingException e = new NamingException("Comparator not found for OID: " + oid);
        throw e;
    }

    @Override
    public boolean hasComparator(String oid) {
        return this.byOid.containsKey(oid);
    }

    @Override
    public String getSchemaName(String oid) throws NamingException {
        if (!Character.isDigit(oid.charAt(0))) {
            throw new NamingException("OID " + oid + " is not a numeric OID");
        }
        if (this.oidToDescription.containsKey(oid)) {
            return DefaultComparatorRegistry.getSchema(this.oidToDescription.get(oid));
        }
        throw new NamingException("OID " + oid + " not found in oid to " + "description map!");
    }

    @Override
    public Iterator<String> oidIterator() {
        return this.byOid.keySet().iterator();
    }

    @Override
    public void unregister(String oid) throws NamingException {
        if (!Character.isDigit(oid.charAt(0))) {
            throw new NamingException("OID " + oid + " is not a numeric OID");
        }
        this.byOid.remove(oid);
        this.oidToDescription.remove(oid);
    }

    @Override
    public void unregisterSchemaElements(String schemaName) {
        ArrayList<String> oids = new ArrayList<String>(this.byOid.keySet());
        for (String oid : oids) {
            ComparatorDescription description = this.oidToDescription.get(oid);
            String schemaNameForOid = DefaultComparatorRegistry.getSchema(description);
            if (!schemaNameForOid.equalsIgnoreCase(schemaName)) continue;
            this.byOid.remove(oid);
            this.oidToDescription.remove(oid);
        }
    }

    @Override
    public void renameSchema(String originalSchemaName, String newSchemaName) {
        ArrayList<String> oids = new ArrayList<String>(this.byOid.keySet());
        for (String oid : oids) {
            ComparatorDescription description = this.oidToDescription.get(oid);
            String schemaNameForOid = DefaultComparatorRegistry.getSchema(description);
            if (!schemaNameForOid.equalsIgnoreCase(originalSchemaName)) continue;
            List schemaExt = (List)description.getExtensions().get("X-SCHEMA");
            schemaExt.clear();
            schemaExt.add(newSchemaName);
        }
    }

    @Override
    public Iterator<ComparatorDescription> comparatorDescriptionIterator() {
        return this.oidToDescription.values().iterator();
    }
}

