/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.api.login;

import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.login.Authenticator;

public class AuthenticationLoginModule
implements LoginModule {
    protected Subject subject;
    protected CallbackHandler callbackHandler;
    protected Map sharedState;
    protected Principal principal;

    public Principal authenticate(String[] login) {
        return Framework.getService(Authenticator.class).authenticate(login[0], login[1]);
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
    }

    protected String[] retrieveLogin() throws LoginException {
        PasswordCallback pc = new PasswordCallback("Password: ", false);
        NameCallback nc = new NameCallback("Username: ", "guest");
        Callback[] callbacks = new Callback[]{nc, pc};
        try {
            String[] login = new String[2];
            this.callbackHandler.handle(callbacks);
            login[0] = nc.getName();
            char[] tmpPassword = pc.getPassword();
            if (tmpPassword != null) {
                login[1] = new String(tmpPassword);
            }
            pc.clearPassword();
            return login;
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException("Error: " + uce.getCallback().toString() + " not available to gather authentication information from the user");
        }
    }

    @Override
    public boolean login() throws LoginException {
        String[] login = this.retrieveLogin();
        try {
            this.principal = this.authenticate(login);
        }
        catch (RuntimeException e) {
            LoginException ee = new LoginException("Authentication failed for " + login[0]);
            ee.initCause(e);
            throw ee;
        }
        if (this.principal == null) {
            throw new LoginException("Authentication failed for " + login[0]);
        }
        this.sharedState.put("javax.security.auth.login.name", this.principal);
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.principal != null) {
            this.subject.getPrincipals().add(this.principal);
            return true;
        }
        return false;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.principal != null) {
            this.subject.getPrincipals().remove(this.principal);
        }
        return true;
    }
}

