/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.api.login;

import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

public class LoginConfiguration
extends Configuration {
    public static final LoginConfiguration INSTANCE = new LoginConfiguration();
    protected Configuration parent = null;
    protected Provider provider = null;
    protected final AtomicInteger counter = new AtomicInteger(0);

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        AppConfigurationEntry[] entries;
        AppConfigurationEntry[] appConfigurationEntryArray = entries = this.provider != null ? this.provider.getAppConfigurationEntry(name) : null;
        if (entries == null) {
            entries = this.parent != null ? this.parent.getAppConfigurationEntry(name) : null;
        }
        return entries;
    }

    @Override
    public void refresh() {
        if (this.parent != null) {
            this.parent.refresh();
        }
    }

    public void install(Provider provider) {
        int count = this.counter.incrementAndGet();
        if (count == 1) {
            this.provider = provider;
            this.parent = Configuration.getConfiguration();
            Configuration.setConfiguration(this);
        }
    }

    public void uninstall() {
        int count = this.counter.decrementAndGet();
        if (count == 0) {
            Configuration.setConfiguration(this.parent);
            this.provider = null;
            this.parent = null;
        }
    }

    public static interface Provider {
        public AppConfigurationEntry[] getAppConfigurationEntry(String var1);
    }
}

