/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.computedgroups;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ecm.core.query.sql.model.Expression;
import org.nuxeo.ecm.core.query.sql.model.MultiExpression;
import org.nuxeo.ecm.core.query.sql.model.QueryBuilder;
import org.nuxeo.ecm.directory.memory.MapExpressionEvaluator;
import org.nuxeo.ecm.platform.computedgroups.GroupComputer;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractGroupComputer
implements GroupComputer {
    protected UserManager getUM() {
        return (UserManager)Framework.getService(UserManager.class);
    }

    @Override
    public List<String> searchGroups(Map<String, Serializable> filter, Set<String> fulltext) {
        List<String> allGroupIds;
        ArrayList<String> result = new ArrayList<String>();
        String grpName = (String)((Object)filter.get(this.getUM().getGroupIdField()));
        if (grpName != null && (allGroupIds = this.getAllGroupIds()) != null) {
            for (String vGroupName : allGroupIds) {
                if (!vGroupName.startsWith(grpName) || result.contains(vGroupName)) continue;
                result.add(vGroupName);
            }
        }
        return result;
    }

    @Override
    public List<String> searchGroups(QueryBuilder queryBuilder) {
        ArrayList<String> groupIds = new ArrayList<String>();
        String groupIdField = ((UserManager)Framework.getService(UserManager.class)).getGroupIdField();
        List<String> allGroupIds = this.getAllGroupIds();
        if (allGroupIds != null) {
            MultiExpression expression = queryBuilder.predicate();
            MapExpressionEvaluator evaluator = new MapExpressionEvaluator();
            for (String groupId : allGroupIds) {
                Map<String, String> entry = Collections.singletonMap(groupIdField, groupId);
                if (!evaluator.matchesEntry((Expression)expression, entry)) continue;
                groupIds.add(groupId);
            }
        }
        return groupIds;
    }

    @Override
    public boolean hasGroup(String name) {
        List<String> allGroupIds = this.getAllGroupIds();
        if (allGroupIds != null) {
            return allGroupIds.contains(name);
        }
        return false;
    }
}

