/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event.pipe.dispatch;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.pipe.EventBundlePipe;
import org.nuxeo.ecm.core.event.pipe.EventPipeDescriptor;
import org.nuxeo.ecm.core.event.pipe.dispatch.EventBundleDispatcher;

public class SimpleEventBundlePipeDispatcher
implements EventBundleDispatcher {
    protected List<EventBundlePipe> pipes = new ArrayList<EventBundlePipe>();
    protected Map<String, String> parameters;

    @Override
    public void init(List<EventPipeDescriptor> pipeDescriptors, Map<String, String> parameters) {
        this.parameters = parameters;
        pipeDescriptors.sort((o1, o2) -> o1.getPriority().compareTo(o2.getPriority()));
        for (EventPipeDescriptor descriptor : pipeDescriptors) {
            EventBundlePipe pipe = descriptor.getInstance();
            pipe.initPipe(descriptor.getName(), descriptor.getParameters());
            this.pipes.add(pipe);
        }
    }

    @Override
    public void sendEventBundle(EventBundle events) {
        if (events.isEmpty()) {
            return;
        }
        for (EventBundlePipe pipe : this.pipes) {
            pipe.sendEventBundle(events);
        }
    }

    @Override
    public boolean waitForCompletion(long timeoutMillis) throws InterruptedException {
        boolean res = true;
        for (EventBundlePipe pipe : this.pipes) {
            res = pipe.waitForCompletion(timeoutMillis) && res;
        }
        return res;
    }

    @Override
    public void shutdown() throws InterruptedException {
        for (EventBundlePipe pipe : this.pipes) {
            pipe.shutdown();
        }
    }
}

