/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.ExprFunction1;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import org.openjena.atlas.lib.IRILib;

public class E_StrEncodeForURI
extends ExprFunction1 {
    private static final String symbol = "encode_for_uri";

    public E_StrEncodeForURI(Expr expr) {
        super(expr, symbol);
    }

    public NodeValue eval(NodeValue v) {
        Node n = v.asNode();
        if (!n.isLiteral()) {
            throw new ExprEvalException("Not a literal");
        }
        if (n.getLiteralDatatype() != null && !n.getLiteralDatatype().equals(XSDDatatype.XSDstring)) {
            throw new ExprEvalException("Not a string literal");
        }
        String str2 = n.getLiteralLexicalForm();
        String encStr = IRILib.encodeUriComponent(str2);
        encStr = IRILib.encodeNonASCII(encStr);
        return NodeValue.makeString(encStr);
    }

    public Expr copy(Expr expr) {
        return new E_StrEncodeForURI(expr);
    }
}

