/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.modify;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.Substitute;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import com.hp.hpl.jena.sparql.modify.UpdateEngine;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.iterator.Transform;
import org.openjena.atlas.lib.MultiMap;
import org.openjena.atlas.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateLib {
    public static MultiMap<Node, Triple> template(List<Quad> quads, final Node dftGraph, List<Binding> bindings) {
        if (quads == null || quads.isEmpty()) {
            return null;
        }
        if (dftGraph != null) {
            Transform<Quad, Quad> nt = new Transform<Quad, Quad>(){

                @Override
                public Quad convert(Quad quad) {
                    if (!quad.isDefaultGraph()) {
                        return quad;
                    }
                    return new Quad(dftGraph, quad.getSubject(), quad.getPredicate(), quad.getObject());
                }
            };
            quads = Iter.map(quads, nt);
        }
        MultiMap<Node, Triple> acc = TemplateLib.calcTriples(quads, bindings);
        return acc;
    }

    public static MultiMap<Node, Triple> calcTriples(List<Quad> quads, List<Binding> bindings) {
        QueryIterPlainWrapper qIter = new QueryIterPlainWrapper(bindings.iterator());
        return TemplateLib.subst(quads, qIter);
    }

    protected static MultiMap<Node, Triple> subst(List<Quad> quads, QueryIterator qIter) {
        MultiMap<Node, Triple> acc = MultiMap.createMapList();
        while (qIter.hasNext()) {
            HashMap<Node, Node> bNodeMap = new HashMap<Node, Node>();
            Binding b = qIter.nextBinding();
            for (Quad quad : quads) {
                TemplateLib.subst(acc, quad, b, bNodeMap);
            }
        }
        return acc;
    }

    static void subst(MultiMap<Node, Triple> acc, Quad quad, Binding b, Map<Node, Node> bNodeMap) {
        Quad q = TemplateLib.subst(quad, b, bNodeMap);
        if (!q.isConcrete()) {
            Log.warn(UpdateEngine.class, "Unbound quad: " + FmtUtils.stringForQuad(quad));
            return;
        }
        acc.put(q.getGraph(), q.asTriple());
    }

    public static Quad subst(Quad quad, Binding b, Map<Node, Node> bNodeMap) {
        Node g = quad.getGraph();
        Node s = quad.getSubject();
        Node p = quad.getPredicate();
        Node o = quad.getObject();
        Node g1 = g;
        Node s1 = s;
        Node p1 = p;
        Node o1 = o;
        if (g1.isBlank() || Var.isBlankNodeVar(g1)) {
            g1 = TemplateLib.newBlank(g1, bNodeMap);
        }
        if (s1.isBlank() || Var.isBlankNodeVar(s1)) {
            s1 = TemplateLib.newBlank(s1, bNodeMap);
        }
        if (p1.isBlank() || Var.isBlankNodeVar(p1)) {
            p1 = TemplateLib.newBlank(p1, bNodeMap);
        }
        if (o1.isBlank() || Var.isBlankNodeVar(o1)) {
            o1 = TemplateLib.newBlank(o1, bNodeMap);
        }
        Quad q = quad;
        if (s1 != s || p1 != p || o1 != o || g1 != g) {
            q = new Quad(g1, s1, p1, o1);
        }
        Quad q2 = Substitute.substitute(q, b);
        return q2;
    }

    public static Triple subst(Triple triple, Binding b, Map<Node, Node> bNodeMap) {
        Node s = triple.getSubject();
        Node p = triple.getPredicate();
        Node o = triple.getObject();
        Node s1 = s;
        Node p1 = p;
        Node o1 = o;
        if (s1.isBlank() || Var.isBlankNodeVar(s1)) {
            s1 = TemplateLib.newBlank(s1, bNodeMap);
        }
        if (p1.isBlank() || Var.isBlankNodeVar(p1)) {
            p1 = TemplateLib.newBlank(p1, bNodeMap);
        }
        if (o1.isBlank() || Var.isBlankNodeVar(o1)) {
            o1 = TemplateLib.newBlank(o1, bNodeMap);
        }
        Triple t = triple;
        if (s1 != s || p1 != p || o1 != o) {
            t = new Triple(s1, p1, o1);
        }
        Triple t2 = Substitute.substitute(t, b);
        return t2;
    }

    private static Node newBlank(Node n, Map<Node, Node> bNodeMap) {
        if (!bNodeMap.containsKey(n)) {
            bNodeMap.put(n, Node.createAnon());
        }
        return bNodeMap.get(n);
    }
}

