/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.resultset;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.resultset.ResultSetApply;
import com.hp.hpl.jena.sparql.resultset.ResultSetException;
import com.hp.hpl.jena.sparql.resultset.ResultSetProcessor;
import java.util.HashMap;
import java.util.Map;
import org.openjena.atlas.json.JsonArray;
import org.openjena.atlas.json.JsonException;
import org.openjena.atlas.json.JsonNull;
import org.openjena.atlas.json.JsonObject;
import org.openjena.atlas.logging.Log;

public class JSONObjectResult
implements ResultSetProcessor {
    static boolean outputExplicitUnbound = false;
    boolean outputGraphBNodeLabels = ARQ.isTrue(ARQ.outputGraphBNodeLabels);
    int bNodeCounter = 0;
    Map<Resource, String> bNodeMap = new HashMap<Resource, String>();
    JsonObject json;
    JsonArray solutions;
    JsonObject currentSolution;

    static JsonObject booleanResult(boolean result) {
        try {
            JsonObject json2 = new JsonObject();
            json2.put("head", new JsonObject());
            json2.put("boolean", result);
            return json2;
        }
        catch (Exception ex) {
            throw new ResultSetException(ex.getMessage(), ex);
        }
    }

    static JsonObject resultSet(ResultSet resultSet) {
        JSONObjectResult xOut = new JSONObjectResult();
        ResultSetApply a = new ResultSetApply(resultSet, xOut);
        a.apply();
        return xOut.json;
    }

    private JSONObjectResult() {
    }

    public void start(ResultSet rs) {
        this.json = new JsonObject();
        try {
            JsonObject head = new JsonObject();
            this.json.put("head", head);
            JsonArray vars = new JsonArray();
            for (String string : rs.getResultVars()) {
                vars.add(string);
            }
            head.put("vars", vars);
            JsonObject results = new JsonObject();
            this.json.put("results", results);
            this.solutions = new JsonArray();
            results.put("bindings", this.solutions);
        }
        catch (JsonException ex) {
            throw new ResultSetException(ex.getMessage(), ex);
        }
    }

    public void finish(ResultSet rs) {
    }

    public void start(QuerySolution qs) {
        this.currentSolution = new JsonObject();
        this.solutions.add(this.currentSolution);
    }

    public void finish(QuerySolution qs) {
        this.currentSolution = null;
    }

    public void binding(String varName, RDFNode node) {
        if (node == null && !outputExplicitUnbound) {
            return;
        }
        try {
            JsonObject val = this.valueAsJSON(node);
            this.currentSolution.put(varName, val);
        }
        catch (JsonException ex) {
            throw new ResultSetException(ex.getMessage(), ex);
        }
    }

    private JsonObject valueAsJSON(RDFNode node) {
        JsonObject jsonValue = new JsonObject();
        if (node == null) {
            jsonValue.put("type", "unbound");
            jsonValue.put("value", JsonNull.instance);
            return jsonValue;
        }
        if (node instanceof Literal) {
            return this.literalAsJSON((Literal)node);
        }
        if (node instanceof Resource) {
            return this.resourceAsJSON((Resource)node);
        }
        Log.warn(this, "Unknown RDFNode type in result set: " + node.getClass());
        return jsonValue;
    }

    private JsonObject resourceAsJSON(Resource resource) {
        JsonObject jsonValue = new JsonObject();
        if (resource.isAnon()) {
            String label;
            if (this.outputGraphBNodeLabels) {
                label = resource.asNode().getBlankNodeId().getLabelString();
            } else {
                if (!this.bNodeMap.containsKey(resource)) {
                    this.bNodeMap.put(resource, "b" + this.bNodeCounter++);
                }
                label = this.bNodeMap.get(resource);
            }
            jsonValue.put("type", "bnode");
            jsonValue.put("value", label);
        } else {
            jsonValue.put("type", "uri");
            jsonValue.put("value", resource.getURI());
        }
        return jsonValue;
    }

    private JsonObject literalAsJSON(Literal literal) {
        JsonObject jsonValue = new JsonObject();
        String datatype = literal.getDatatypeURI();
        String lang = literal.getLanguage();
        if (datatype != null && !datatype.equals("")) {
            jsonValue.put("type", "typed-literal");
            jsonValue.put("datatype", datatype);
        } else {
            jsonValue.put("type", "literal");
        }
        if (lang != null && lang.length() != 0) {
            jsonValue.put("xml:lang", lang);
        }
        jsonValue.put("value", literal.getLexicalForm());
        return jsonValue;
    }
}

