/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CloseableCoreSession;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.io.DocumentTranslationMap;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.api.Logs;
import org.nuxeo.ecm.platform.audit.io.IOAuditResources;
import org.nuxeo.ecm.platform.audit.io.IOLogEntryBase;
import org.nuxeo.ecm.platform.io.api.AbstractIOResourceAdapter;
import org.nuxeo.ecm.platform.io.api.IOResources;
import org.nuxeo.runtime.api.Framework;

public class IOAuditAdapter
extends AbstractIOResourceAdapter {
    private static final Log log = LogFactory.getLog(IOAuditAdapter.class);
    private static final long serialVersionUID = -3661302796286246086L;

    protected IOLogEntryBase getLogEntryHelper() {
        return new IOLogEntryBase();
    }

    public void setProperties(Map<String, Serializable> properties) {
    }

    public IOResources extractResources(String repo, Collection<DocumentRef> sources) {
        if (sources == null || sources.isEmpty()) {
            return null;
        }
        try (CloseableCoreSession session = CoreInstance.openCoreSessionSystem((String)repo);){
            HashMap<DocumentRef, List<LogEntry>> docLogs = new HashMap<DocumentRef, List<LogEntry>>();
            Logs logService = (Logs)Framework.getService(Logs.class);
            for (DocumentRef docRef : sources) {
                try {
                    String uuid;
                    if (docRef.type() == 1) {
                        uuid = docRef.toString();
                    } else {
                        DocumentModel doc = session.getDocument(docRef);
                        uuid = doc.getId();
                    }
                    List logEntries = logService.getLogEntriesFor(uuid, repo);
                    docLogs.put(docRef, logEntries);
                }
                catch (DocumentNotFoundException e) {
                    List emptyList = Collections.emptyList();
                    docLogs.put(docRef, emptyList);
                }
            }
            IOAuditResources iOAuditResources = new IOAuditResources(docLogs);
            return iOAuditResources;
        }
    }

    public void getResourcesAsXML(OutputStream out, IOResources resources) {
        if (!(resources instanceof IOAuditResources)) {
            return;
        }
        IOAuditResources auditResources = (IOAuditResources)resources;
        ArrayList<LogEntry> logEntries = new ArrayList<LogEntry>();
        Map<DocumentRef, List<LogEntry>> docLogs = auditResources.getLogsMap();
        Collection<List<LogEntry>> all = docLogs.values();
        for (List<LogEntry> list : all) {
            logEntries.addAll(list);
        }
        try {
            IOLogEntryBase.write(logEntries, out);
        }
        catch (IOException e) {
            throw new NuxeoException("Cannot write logs", (Throwable)e);
        }
    }

    public IOResources loadResourcesFromXML(InputStream stream) {
        List<LogEntry> allEntries;
        try {
            allEntries = IOLogEntryBase.read(stream);
        }
        catch (IOException e) {
            throw new NuxeoException("Cannot read entries from " + stream);
        }
        HashMap<DocumentRef, List<LogEntry>> docLogs = new HashMap<DocumentRef, List<LogEntry>>();
        for (LogEntry logEntry : allEntries) {
            IdRef docRef = new IdRef(logEntry.getDocUUID());
            ArrayList<LogEntry> logEntries = (ArrayList<LogEntry>)docLogs.get(docRef);
            if (logEntries == null) {
                logEntries = new ArrayList<LogEntry>();
                docLogs.put((DocumentRef)docRef, logEntries);
            }
            logEntries.add(logEntry);
        }
        return new IOAuditResources(docLogs);
    }

    public void storeResources(IOResources newResources) {
        if (!(newResources instanceof IOAuditResources)) {
            return;
        }
        Logs logService = (Logs)Framework.getService(Logs.class);
        IOAuditResources auditResources = (IOAuditResources)newResources;
        Map<DocumentRef, List<LogEntry>> docLogs = auditResources.getLogsMap();
        for (Map.Entry<DocumentRef, List<LogEntry>> mapEntry : docLogs.entrySet()) {
            DocumentRef docRef = mapEntry.getKey();
            List<LogEntry> logs = mapEntry.getValue();
            List<LogEntry> newLogs = IOLogEntryBase.translate(logs, docRef);
            logService.addLogEntries(newLogs);
        }
    }

    public IOResources translateResources(String repo, IOResources resources, DocumentTranslationMap map) {
        if (map == null) {
            return null;
        }
        if (!(resources instanceof IOAuditResources)) {
            return resources;
        }
        IOAuditResources auditResources = (IOAuditResources)resources;
        HashMap<DocumentRef, List<LogEntry>> newResourcesMap = new HashMap<DocumentRef, List<LogEntry>>();
        for (Map.Entry<DocumentRef, List<LogEntry>> entry : auditResources.getLogsMap().entrySet()) {
            DocumentRef oldRef = entry.getKey();
            DocumentRef newRef = (DocumentRef)map.getDocRefMap().get(oldRef);
            if (newRef == null) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)("newRef does not exist in translation map for " + oldRef));
                continue;
            }
            List<LogEntry> docLogs = auditResources.getDocumentLogs(oldRef);
            List<LogEntry> newLogs = IOLogEntryBase.translate(docLogs, newRef);
            newResourcesMap.put(newRef, newLogs);
        }
        return new IOAuditResources(newResourcesMap);
    }
}

