/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.bulk.computation;

import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.CloseableCoreSession;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.ScrollResult;
import org.nuxeo.ecm.core.bulk.BulkAdminService;
import org.nuxeo.ecm.core.bulk.BulkCodecs;
import org.nuxeo.ecm.core.bulk.BulkService;
import org.nuxeo.ecm.core.bulk.message.BulkBucket;
import org.nuxeo.ecm.core.bulk.message.BulkCommand;
import org.nuxeo.ecm.core.bulk.message.BulkStatus;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.lib.stream.computation.AbstractComputation;
import org.nuxeo.lib.stream.computation.ComputationContext;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.lib.stream.computation.internals.ComputationContextImpl;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class BulkScrollerComputation
extends AbstractComputation {
    private static final Logger log = LogManager.getLogger(BulkScrollerComputation.class);
    public static final int MAX_SCROLL_SIZE = 4000;
    protected final int scrollBatchSize;
    protected final int scrollKeepAliveSeconds;
    protected final List<String> documentIds;
    private final boolean produceImmediate;

    public BulkScrollerComputation(String name, int nbOutputStreams, int scrollBatchSize, int scrollKeepAliveSeconds, boolean produceImmediate) {
        super(name, 1, nbOutputStreams);
        this.scrollBatchSize = scrollBatchSize;
        this.scrollKeepAliveSeconds = scrollKeepAliveSeconds;
        this.produceImmediate = produceImmediate;
        this.documentIds = new ArrayList<String>(scrollBatchSize);
    }

    public void processRecord(ComputationContext context, String inputStreamName, Record record) {
        TransactionHelper.runInTransaction(() -> this.processRecord(context, record));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRecord(ComputationContext context, Record record) {
        BulkCommand command = null;
        try {
            command = (BulkCommand)BulkCodecs.getCommandCodec().decode(record.getData());
            String commandId = command.getId();
            int bucketSize = command.getBucketSize() > 0 ? command.getBucketSize() : ((BulkAdminService)Framework.getService(BulkAdminService.class)).getBucketSize(command.getAction());
            int scrollSize = this.scrollBatchSize;
            if (bucketSize > scrollSize) {
                if (bucketSize <= 4000) {
                    scrollSize = bucketSize;
                } else {
                    log.warn("Bucket size: %d too big for command: %s, reduce to: %d", (Object)bucketSize, (Object)command, (Object)4000);
                    bucketSize = 4000;
                    scrollSize = 4000;
                }
            }
            this.updateStatusAsScrolling(context, commandId);
            String username = command.getUsername();
            LoginContext loginContext = "system".equals(username) ? Framework.login() : Framework.loginAsUser((String)username);
            try (CloseableCoreSession session = CoreInstance.openCoreSession((String)command.getRepository());){
                ScrollResult scroll = session.scroll(command.getQuery(), scrollSize, this.scrollKeepAliveSeconds);
                long documentCount = 0L;
                long bucketNumber = 1L;
                while (scroll.hasResults()) {
                    if (this.isAbortedCommand(commandId)) {
                        log.debug("Skipping aborted command: {}", (Object)commandId);
                        context.askForCheckpoint();
                        return;
                    }
                    List docIds = scroll.getResults();
                    this.documentIds.addAll(docIds);
                    while (this.documentIds.size() >= bucketSize) {
                        this.produceBucket(context, command.getAction(), commandId, bucketSize, bucketNumber++);
                    }
                    documentCount += (long)docIds.size();
                    scroll = session.scroll(scroll.getScrollId());
                    TransactionHelper.commitOrRollbackTransaction();
                    TransactionHelper.startTransaction();
                }
                if (!this.documentIds.isEmpty()) {
                    this.produceBucket(context, command.getAction(), commandId, bucketSize, bucketNumber++);
                }
                this.updateStatusAfterScroll(context, commandId, documentCount);
            }
            catch (IllegalArgumentException | DocumentNotFoundException | QueryParseException e) {
                log.error("Invalid query results in an empty document set: {}", (Object)command, (Object)e);
                this.updateStatusAfterScroll(context, commandId, "Invalid query");
            }
            finally {
                if (loginContext != null) {
                    loginContext.logout();
                }
            }
        }
        catch (LoginException | NuxeoException e) {
            if (command != null) {
                log.error("Invalid command produces an empty document set: {}", (Object)command, (Object)e);
                this.updateStatusAfterScroll(context, command.getId(), "Invalid command");
            }
            log.error("Discard invalid record: {}", (Object)record, (Object)e);
        }
        context.askForCheckpoint();
    }

    protected boolean isAbortedCommand(String commandId) {
        BulkService bulkService = (BulkService)Framework.getService(BulkService.class);
        BulkStatus status = (BulkStatus)bulkService.getStatus((Serializable)((Object)commandId));
        return BulkStatus.State.ABORTED.equals((Object)status.getState());
    }

    protected void updateStatusAsScrolling(ComputationContext context, String commandId) {
        BulkStatus delta = BulkStatus.deltaOf(commandId);
        delta.setState(BulkStatus.State.SCROLLING_RUNNING);
        delta.setScrollStartTime(Instant.now());
        ((ComputationContextImpl)context).produceRecordImmediate("status", commandId, BulkCodecs.getStatusCodec().encode((Object)delta));
    }

    protected void updateStatusAfterScroll(ComputationContext context, String commandId, String errorMessage) {
        this.updateStatusAfterScroll(context, commandId, 0L, errorMessage);
    }

    protected void updateStatusAfterScroll(ComputationContext context, String commandId, long documentCount) {
        this.updateStatusAfterScroll(context, commandId, documentCount, null);
    }

    protected void updateStatusAfterScroll(ComputationContext context, String commandId, long documentCount, String errorMessage) {
        BulkStatus delta = BulkStatus.deltaOf(commandId);
        if (errorMessage != null) {
            delta.inError(errorMessage);
        }
        if (documentCount == 0L) {
            delta.setState(BulkStatus.State.COMPLETED);
            delta.setCompletedTime(Instant.now());
        } else {
            delta.setState(BulkStatus.State.RUNNING);
        }
        delta.setScrollEndTime(Instant.now());
        delta.setTotal(documentCount);
        ((ComputationContextImpl)context).produceRecordImmediate("status", commandId, BulkCodecs.getStatusCodec().encode((Object)delta));
    }

    protected void produceBucket(ComputationContext context, String action, String commandId, int bucketSize, long bucketNumber) {
        List<String> ids = this.documentIds.subList(0, Math.min(bucketSize, this.documentIds.size()));
        BulkBucket bucket = new BulkBucket(commandId, ids);
        String key = commandId + ":" + Long.toString(bucketNumber);
        Record record = Record.of((String)key, (byte[])BulkCodecs.getBucketCodec().encode((Object)bucket));
        if (this.produceImmediate) {
            ((ComputationContextImpl)context).produceRecordImmediate(action, record);
        } else {
            context.produceRecord(action, record);
        }
        ids.clear();
    }
}

