/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.core.service;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutTypeDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetReference;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetType;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetTypeDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.service.LayoutManager;
import org.nuxeo.ecm.platform.forms.layout.api.service.LayoutStore;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public abstract class AbstractLayoutManager
extends DefaultComponent
implements LayoutManager {
    private static final long serialVersionUID = 1L;

    public abstract String getDefaultStoreCategory();

    protected String getStoreCategory(String cat) {
        if (StringUtils.isBlank((CharSequence)cat)) {
            return this.getDefaultStoreCategory();
        }
        return cat;
    }

    protected LayoutStore getLayoutStore() {
        return (LayoutStore)Framework.getService(LayoutStore.class);
    }

    protected WidgetDefinition lookupWidget(LayoutDefinition layoutDef, WidgetReference widgetRef) {
        String widgetName = widgetRef.getName();
        WidgetDefinition wDef = null;
        if (layoutDef != null && (wDef = layoutDef.getWidgetDefinition(widgetName)) != null && wDef.getType() == null) {
            wDef = null;
        }
        if (wDef == null) {
            wDef = this.lookupWidget(widgetRef);
        }
        return wDef;
    }

    protected WidgetDefinition lookupWidget(WidgetReference widgetRef) {
        String widgetName = widgetRef.getName();
        String cat = widgetRef.getCategory();
        WidgetDefinition wDef = StringUtils.isBlank((CharSequence)cat) ? this.getWidgetDefinition(widgetName) : this.getLayoutStore().getWidgetDefinition(cat, widgetName);
        if (wDef != null) {
            wDef.setGlobal(true);
        }
        return wDef;
    }

    public WidgetType getWidgetType(String typeName) {
        return this.getLayoutStore().getWidgetType(this.getDefaultStoreCategory(), typeName);
    }

    public WidgetTypeDefinition getWidgetTypeDefinition(String typeName) {
        return this.getLayoutStore().getWidgetTypeDefinition(this.getDefaultStoreCategory(), typeName);
    }

    public List<WidgetTypeDefinition> getWidgetTypeDefinitions() {
        return this.getLayoutStore().getWidgetTypeDefinitions(this.getDefaultStoreCategory());
    }

    public LayoutTypeDefinition getLayoutTypeDefinition(String typeName) {
        return this.getLayoutStore().getLayoutTypeDefinition(this.getDefaultStoreCategory(), typeName);
    }

    public List<LayoutTypeDefinition> getLayoutTypeDefinitions() {
        return this.getLayoutStore().getLayoutTypeDefinitions(this.getDefaultStoreCategory());
    }

    public LayoutDefinition getLayoutDefinition(String layoutName) {
        return this.getLayoutStore().getLayoutDefinition(this.getDefaultStoreCategory(), layoutName);
    }

    public List<String> getLayoutDefinitionNames() {
        return this.getLayoutStore().getLayoutDefinitionNames(this.getDefaultStoreCategory());
    }

    public WidgetDefinition getWidgetDefinition(String widgetName) {
        return this.getLayoutStore().getWidgetDefinition(this.getDefaultStoreCategory(), widgetName);
    }

    protected void registerWidgetType(WidgetTypeDefinition desc) {
        this.getLayoutStore().registerWidgetType(this.getDefaultStoreCategory(), desc);
    }

    protected void unregisterWidgetType(WidgetTypeDefinition desc) {
        this.getLayoutStore().unregisterWidgetType(this.getDefaultStoreCategory(), desc);
    }

    protected void registerLayoutType(LayoutTypeDefinition desc) {
        this.getLayoutStore().registerLayoutType(this.getDefaultStoreCategory(), desc);
    }

    protected void unregisterLayoutType(LayoutTypeDefinition desc) {
        this.getLayoutStore().unregisterLayoutType(this.getDefaultStoreCategory(), desc);
    }

    protected void registerLayout(LayoutDefinition layoutDef) {
        this.getLayoutStore().registerLayout(this.getDefaultStoreCategory(), layoutDef);
    }

    protected void unregisterLayout(LayoutDefinition layoutDef) {
        this.getLayoutStore().unregisterLayout(this.getDefaultStoreCategory(), layoutDef);
    }

    protected void registerWidget(WidgetDefinition widgetDef) {
        this.getLayoutStore().registerWidget(this.getDefaultStoreCategory(), widgetDef);
    }

    protected void unregisterWidget(WidgetDefinition widgetDef) {
        this.getLayoutStore().unregisterWidget(this.getDefaultStoreCategory(), widgetDef);
    }
}

