/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.task.update;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.common.utils.FileVersion;
import org.nuxeo.connect.update.task.update.UpdateOptions;

public class Version {
    protected String version;
    protected String path;
    protected Map<String, UpdateOptions> packages;

    public Version(String version) {
        this.version = version;
        this.packages = new HashMap<String, UpdateOptions>();
    }

    public final Map<String, UpdateOptions> getPackages() {
        return this.packages;
    }

    public boolean hasPackage(String pkgId) {
        return this.packages.containsKey(pkgId);
    }

    public boolean removePackage(String pkgId) {
        return this.packages.remove(pkgId) != null;
    }

    public boolean addPackage(UpdateOptions opt) {
        return this.packages.put(opt.getPackageId(), opt) != null;
    }

    public boolean hasPackages() {
        return !this.packages.isEmpty();
    }

    public final String getPath() {
        return this.path;
    }

    public final void setPath(String path) {
        this.path = path;
    }

    public final String getVersion() {
        return this.version;
    }

    public final FileVersion getFileVersion() {
        return new FileVersion(this.version);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Version) {
            return ((Version)obj).version.equals(this.version);
        }
        return false;
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    public String toString() {
        return this.version;
    }
}

