/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.connect.update.LocalPackage;

public class IOUtils {
    private IOUtils() {
    }

    public static File backup(LocalPackage pkg, File file) throws IOException {
        file = file.getCanonicalFile();
        String md5 = IOUtils.createMd5(file.getAbsolutePath());
        File bak = pkg.getData().getEntry("backup");
        bak.mkdirs();
        String name = file.getName();
        File bakFile = new File(bak, md5 + "_" + name);
        FileUtils.copy((File)file, (File)bakFile);
        return bakFile;
    }

    public static String createMd5(String text) throws IOException {
        MessageDigest digest = IOUtils.getMD5Digest();
        digest.update(text.getBytes());
        byte[] hash = digest.digest();
        return IOUtils.md5ToHex(hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createMd5(File file) throws IOException {
        MessageDigest digest = IOUtils.getMD5Digest();
        try (FileInputStream in = new FileInputStream(file);){
            byte[] bytes = new byte[65536];
            int r = in.read(bytes);
            while (r > -1) {
                if (r > 0) {
                    digest.update(bytes, 0, r);
                }
                r = in.read(bytes);
            }
            byte[] hash = digest.digest();
            String string = IOUtils.md5ToHex(hash);
            return string;
        }
    }

    protected static MessageDigest getMD5Digest() throws IOException {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
    }

    public static String md5ToHex(byte[] hash) {
        StringBuilder hexString = new StringBuilder();
        for (byte b : hash) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }
}

