/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.aggregate;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collection;
import java.util.Collections;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.query.api.AggregateDefinition;
import org.nuxeo.ecm.platform.query.core.BucketTerm;
import org.nuxeo.elasticsearch.aggregate.AggregateEsBase;

public abstract class SingleBucketAggregate
extends AggregateEsBase<SingleBucketAggregation, BucketTerm> {
    protected long docCount;

    public SingleBucketAggregate(AggregateDefinition definition, DocumentModel searchDocument) {
        super(definition, searchDocument);
    }

    @Override
    public void parseAggregation(SingleBucketAggregation aggregation) {
        this.docCount = aggregation.getDocCount();
        this.buckets = Collections.singletonList(new BucketTerm(this.definition.getType(), this.docCount));
    }

    @Override
    @JsonIgnore
    public QueryBuilder getEsFilter() {
        if (this.getSelection().isEmpty()) {
            return null;
        }
        return QueryBuilders.termsQuery((String)this.getField(), (Collection)this.getSelection());
    }

    public long getDocCount() {
        return this.docCount;
    }
}

