/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.fetcher;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.nuxeo.ecm.core.api.CloseableCoreSession;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.query.sql.NXQL;
import org.nuxeo.elasticsearch.fetcher.Fetcher;

public class VcsFetcher
extends Fetcher {
    private static final int CHUNK_SIZE = 100;

    public VcsFetcher(CoreSession session, SearchResponse response, Map<String, String> repoNames) {
        super(session, response, repoNames);
    }

    @Override
    public DocumentModelListImpl fetchDocuments() {
        Map<String, List<String>> repoHits = this.getHitsPerRepository();
        List<DocumentModel> docs = this.fetchFromVcs(repoHits);
        this.sortResults(docs);
        this.addHighlights(docs);
        DocumentModelListImpl ret = new DocumentModelListImpl(docs.size());
        if (!docs.isEmpty()) {
            ret.addAll(docs);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<DocumentModel> fetchFromVcs(Map<String, List<String>> repoHits) {
        ArrayList<DocumentModel> docs = new ArrayList<DocumentModel>();
        String openSessionRepository = this.getSession().getRepositoryName();
        for (String repo : repoHits.keySet()) {
            boolean closeSession;
            CoreSession session;
            if (openSessionRepository.equals(repo)) {
                session = this.getSession();
                closeSession = false;
            } else {
                session = CoreInstance.openCoreSession((String)repo);
                closeSession = true;
            }
            try {
                docs.addAll(this.fetchFromVcs(repoHits.get(repo), session));
            }
            finally {
                if (!closeSession) continue;
                ((CloseableCoreSession)session).close();
            }
        }
        return docs;
    }

    private Map<String, List<String>> getHitsPerRepository() {
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
        for (SearchHit hit : this.getResponse().getHits()) {
            String repoName = this.getRepoForIndex(hit.getIndex());
            List docIds = ret.computeIfAbsent(repoName, k -> new ArrayList());
            docIds.add(hit.getId());
        }
        return ret;
    }

    private List<DocumentModel> fetchFromVcs(List<String> ids, CoreSession session) {
        List<DocumentModel> ret = null;
        int size = ids.size();
        int start = 0;
        int end = Math.min(100, size);
        boolean done = false;
        while (!done) {
            List<DocumentModel> docs = this.fetchFromVcsChunk(ids.subList(start, end), session);
            if (ret == null) {
                ret = docs;
            } else {
                ret.addAll(docs);
            }
            if (end >= ids.size()) {
                done = true;
                continue;
            }
            start = end;
            end = Math.min(start + 100, size);
        }
        return ret;
    }

    private List<DocumentModel> fetchFromVcsChunk(List<String> ids, CoreSession session) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT * FROM Document, Relation WHERE ecm:uuid IN (");
        for (int i = 0; i < ids.size(); ++i) {
            sb.append(NXQL.escapeString((String)ids.get(i)));
            if (i >= ids.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return session.query(sb.toString());
    }

    private void addHighlights(List<DocumentModel> docs) {
        block0: for (SearchHit hit : this.getResponse().getHits()) {
            for (DocumentModel doc : docs) {
                String hitId;
                String docId = doc.getRepositoryName() + doc.getId();
                if (!docId.equals(hitId = this.getRepoForIndex(hit.getIndex()) + hit.getId())) continue;
                Map esHighlights = hit.getHighlightFields();
                if (esHighlights.isEmpty()) continue block0;
                HashMap fields = new HashMap();
                for (Map.Entry entry : esHighlights.entrySet()) {
                    String field = (String)entry.getKey();
                    ArrayList<String> list = new ArrayList<String>();
                    for (Text fragment : ((HighlightField)entry.getValue()).getFragments()) {
                        list.add(fragment.toString());
                    }
                    fields.put(field, list);
                }
                doc.putContextData("highlight", (Serializable)fields);
                continue block0;
            }
        }
    }

    private void sortResults(List<DocumentModel> docs) {
        final ArrayList<CallSite> ids = new ArrayList<CallSite>();
        for (SearchHit hit : this.getResponse().getHits()) {
            ids.add((CallSite)((Object)(this.getRepoForIndex(hit.getIndex()) + hit.getId())));
        }
        docs.sort(new Comparator<DocumentModel>(){

            @Override
            public int compare(DocumentModel a, DocumentModel b) {
                return ids.indexOf(a.getRepositoryName() + a.getId()) - ids.indexOf(b.getRepositoryName() + b.getId());
            }
        });
    }
}

