/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.hint;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.elasticsearch.api.ESHintQueryBuilder;

public abstract class AbstractGeoESHintQueryBuilder
implements ESHintQueryBuilder {
    protected String[] validate(Object value, int arrayLength, String message) {
        if (!(value instanceof Object[])) {
            throw new NuxeoException(String.format("Expected an array, found %s", value.getClass()), 400);
        }
        Object[] values = (Object[])value;
        if (values.length != arrayLength) {
            throw new NuxeoException(String.format("Hints: %s requires %s parameters: %s", this.getClass().getSimpleName(), arrayLength, message), 400);
        }
        return Arrays.asList(values).toArray(new String[0]);
    }

    protected GeoPoint parseGeoPointString(String value) {
        GeoPoint geoPoint;
        block8: {
            XContentBuilder content = JsonXContent.contentBuilder();
            content.value(value);
            content.flush();
            content.close();
            XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, ((ByteArrayOutputStream)content.getOutputStream()).toByteArray());
            try {
                parser.nextToken();
                geoPoint = GeoUtils.parseGeoPoint((XContentParser)parser);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | ElasticsearchParseException e) {
                    throw new NuxeoException(String.format("Invalid value for Geo-point: %s", value), e, 400);
                }
            }
            parser.close();
        }
        return geoPoint;
    }
}

