/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.work;

import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ScrollResult;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.elasticsearch.work.BaseIndexingWorker;
import org.nuxeo.elasticsearch.work.BucketIndexingWorker;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class ScrollingIndexingWorker
extends BaseIndexingWorker
implements Work {
    private static final Log log = LogFactory.getLog(ScrollingIndexingWorker.class);
    private static final long serialVersionUID = -4507677669419340384L;
    private static final String DEFAULT_BUCKET_SIZE = "500";
    private static final long WARN_DOC_COUNT = 500L;
    protected final String nxql;
    protected final boolean syncAlias;
    protected transient WorkManager workManager;
    protected long documentCount;

    public ScrollingIndexingWorker(String repositoryName, String nxql) {
        this(repositoryName, nxql, false);
    }

    public ScrollingIndexingWorker(String repositoryName, String nxql, boolean syncAlias) {
        this.repositoryName = repositoryName;
        this.nxql = nxql;
        this.syncAlias = syncAlias;
    }

    public String getTitle() {
        return "Elasticsearch scrolling indexer: " + this.nxql + ", processed " + this.documentCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void doWork() {
        String jobName = this.getSchedulePath().getPath();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Re-indexing job: %s started, NXQL: %s on repository: %s", jobName, this.nxql, this.repositoryName));
        }
        this.openSystemSession();
        int bucketSize = this.getBucketSize();
        ScrollResult ret = this.session.scroll(this.nxql, bucketSize, 60);
        int bucketCount = 0;
        try {
            while (ret.hasResults()) {
                this.documentCount += (long)ret.getResults().size();
                this.scheduleBucketWorker(ret.getResults(), false);
                ++bucketCount;
                ret = this.session.scroll(ret.getScrollId());
                TransactionHelper.commitOrRollbackTransaction();
                TransactionHelper.startTransaction();
            }
            if (this.syncAlias) {
                this.scheduleBucketWorker(Collections.emptyList(), true);
            }
            if (!this.syncAlias && this.documentCount <= 500L) return;
        }
        catch (Throwable throwable) {
            if (!this.syncAlias && this.documentCount <= 500L) throw throwable;
            String message = String.format("Re-indexing job: %s has submited %d documents in %d bucket workers", jobName, this.documentCount, bucketCount);
            if (this.syncAlias) {
                log.warn((Object)message);
                throw throwable;
            } else {
                log.debug((Object)message);
            }
            throw throwable;
        }
        String message = String.format("Re-indexing job: %s has submited %d documents in %d bucket workers", jobName, this.documentCount, bucketCount);
        if (this.syncAlias) {
            log.warn((Object)message);
            return;
        } else {
            log.debug((Object)message);
        }
    }

    protected void scheduleBucketWorker(List<String> bucket, boolean syncAlias) {
        if (bucket.isEmpty() && !syncAlias) {
            return;
        }
        BucketIndexingWorker subWorker = new BucketIndexingWorker(this.repositoryName, bucket, syncAlias);
        this.getWorkManager().schedule((Work)subWorker);
    }

    protected WorkManager getWorkManager() {
        if (this.workManager == null) {
            this.workManager = (WorkManager)Framework.getService(WorkManager.class);
        }
        return this.workManager;
    }

    protected int getBucketSize() {
        String value = Framework.getProperty((String)"elasticsearch.reindex.bucketReadSize", (String)DEFAULT_BUCKET_SIZE);
        return Integer.parseInt(value);
    }
}

