/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.content.template.factories;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.platform.content.template.factories.BaseContentFactory;
import org.nuxeo.ecm.platform.content.template.service.ACEDescriptor;
import org.nuxeo.ecm.platform.content.template.service.PropertyDescriptor;
import org.nuxeo.ecm.platform.content.template.service.TemplateItemDescriptor;

public class SimpleTemplateBasedFactory
extends BaseContentFactory {
    protected List<TemplateItemDescriptor> template;
    protected List<ACEDescriptor> acl;

    protected boolean isTargetEmpty(DocumentModel eventDoc) {
        return this.session.getChildren(eventDoc.getRef()).isEmpty();
    }

    @Override
    public void createContentStructure(DocumentModel eventDoc) {
        this.initSession(eventDoc);
        if (eventDoc.isVersion() || !this.isTargetEmpty(eventDoc)) {
            return;
        }
        this.setAcl(this.acl, eventDoc.getRef());
        for (TemplateItemDescriptor item : this.template) {
            Object itemPath = eventDoc.getPathAsString();
            if (item.getPath() != null) {
                itemPath = (String)itemPath + "/" + item.getPath();
            }
            DocumentModel newChild = this.session.createDocumentModel((String)itemPath, item.getId(), item.getTypeName());
            newChild.setProperty("dublincore", "title", (Object)item.getTitle());
            newChild.setProperty("dublincore", "description", (Object)item.getDescription());
            this.setProperties(item.getProperties(), newChild);
            newChild = this.session.createDocument(newChild);
            this.setAcl(item.getAcl(), newChild.getRef());
        }
    }

    protected void setProperties(List<PropertyDescriptor> properties, DocumentModel doc) {
        if (properties != null && !properties.isEmpty()) {
            for (PropertyDescriptor property : properties) {
                doc.setPropertyValue(property.getXpath(), (Serializable)((Object)property.getValue()));
            }
        }
    }

    protected void setAcl(List<ACEDescriptor> aces, DocumentRef ref) {
        if (aces != null && !aces.isEmpty()) {
            ACP acp = this.session.getACP(ref);
            ACL existingACL = acp.getOrCreateACL();
            existingACL.clear();
            for (ACEDescriptor ace : aces) {
                existingACL.add(new ACE(ace.getPrincipal(), ace.getPermission(), ace.getGranted()));
            }
            acp.addACL(existingACL);
            this.session.setACP(ref, acp, true);
        }
    }

    @Override
    public boolean initFactory(Map<String, String> options, List<ACEDescriptor> rootAcl, List<TemplateItemDescriptor> template) {
        this.template = template;
        this.acl = rootAcl;
        return true;
    }
}

