/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.rest;

import java.io.Serializable;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.platform.web.common.ServletHelper;
import org.nuxeo.ecm.webengine.forms.FormData;
import org.nuxeo.ecm.webengine.model.WebAdapter;
import org.nuxeo.ecm.webengine.model.exceptions.IllegalParameterException;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.impl.DefaultAdapter;

@WebAdapter(name="file", type="FileService", targetType="Document")
public class FileService
extends DefaultAdapter {
    @GET
    public Response doGet(@Context Request request) {
        DocumentModel doc = (DocumentModel)this.getTarget().getAdapter(DocumentModel.class);
        FormData form = this.ctx.getForm();
        String xpath = form.getString("property");
        if (xpath == null) {
            if (doc.hasSchema("file")) {
                xpath = "file:content";
            } else {
                throw new IllegalParameterException("Missing request parameter named 'property' that specify the blob property xpath to fetch");
            }
        }
        try {
            Response.ResponseBuilder builder;
            String digest;
            EntityTag etag;
            Property p = doc.getProperty(xpath);
            Blob blob = (Blob)p.getValue();
            if (blob == null) {
                throw new WebResourceNotFoundException("No attached file at " + xpath);
            }
            String fileName = blob.getFilename();
            if (fileName == null) {
                fileName = "Unknown";
            }
            EntityTag entityTag = etag = (digest = blob.getDigest()) == null ? null : new EntityTag(digest);
            if (etag != null && (builder = request.evaluatePreconditions(etag)) != null) {
                return builder.build();
            }
            String contentDisposition = ServletHelper.getRFC2231ContentDisposition((HttpServletRequest)this.ctx.getRequest(), (String)fileName);
            Response.ResponseBuilder builder2 = Response.ok((Object)blob).header("Content-Disposition", (Object)contentDisposition).type(blob.getMimeType());
            if (etag != null) {
                builder2.tag(etag);
            }
            return builder2.build();
        }
        catch (NuxeoException e) {
            e.addInfo("Failed to get the attached file");
            throw e;
        }
    }

    @POST
    public Response doPost() {
        Blob blob;
        DocumentModel doc = (DocumentModel)this.getTarget().getAdapter(DocumentModel.class);
        FormData form = this.ctx.getForm();
        form.fillDocument(doc);
        String xpath = this.ctx.getForm().getString("property");
        if (xpath == null) {
            if (doc.hasSchema("file")) {
                xpath = "file:content";
            } else if (doc.hasSchema("files")) {
                xpath = "files:files";
            } else {
                throw new IllegalArgumentException("Missing request parameter named 'property' that specifies the blob property xpath to fetch");
            }
        }
        if ((blob = form.getFirstBlob()) == null) {
            throw new IllegalArgumentException("Could not find any uploaded file");
        }
        try {
            Property p = doc.getProperty(xpath);
            if (p.isList()) {
                if ("files".equals(p.getSchema().getName())) {
                    HashMap<String, Serializable> map = new HashMap<String, Serializable>();
                    map.put("file", (Serializable)blob);
                    p.addValue(map);
                } else {
                    p.addValue((Object)blob);
                }
            } else {
                p.setValue((Object)blob);
            }
            doc.putContextData("VersioningOption", (Serializable)form.getVersioningOption());
            CoreSession session = this.ctx.getCoreSession();
            session.saveDocument(doc);
            session.save();
            return this.redirect(this.getTarget().getPath());
        }
        catch (NuxeoException e) {
            e.addInfo("Failed to attach file");
            throw e;
        }
    }

    @GET
    @Path(value="delete")
    public Response remove() {
        return this.doDelete();
    }

    @DELETE
    public Response doDelete() {
        DocumentModel doc = (DocumentModel)this.getTarget().getAdapter(DocumentModel.class);
        FormData form = this.ctx.getForm();
        String xpath = form.getString("property");
        if (xpath == null) {
            if (doc.hasSchema("file")) {
                xpath = "file:content";
            } else {
                throw new IllegalArgumentException("Missing request parameter named 'property' that specifies the blob property xpath to fetch");
            }
        }
        try {
            doc.getProperty(xpath).remove();
            CoreSession session = this.ctx.getCoreSession();
            session.saveDocument(doc);
            session.save();
        }
        catch (NuxeoException e) {
            e.addInfo("Failed to delete attached file");
            throw e;
        }
        return this.redirect(this.getTarget().getPath());
    }
}

