/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.aci;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.directory.shared.ldap.aci.GrantAndDenial;
import org.apache.directory.shared.ldap.aci.Permission;
import org.apache.directory.shared.ldap.aci.UserClass;

public class ItemPermission
extends Permission {
    private static final long serialVersionUID = 3940100745409337694L;
    private final Collection userClasses;

    public ItemPermission(int precedence, Collection grantsAndDenials, Collection userClasses) {
        super(precedence, grantsAndDenials);
        for (Object val : userClasses) {
            if (val instanceof UserClass) continue;
            throw new IllegalArgumentException("userClasses contains a wrong element.");
        }
        this.userClasses = Collections.unmodifiableCollection(new ArrayList(userClasses));
    }

    public Collection getUserClasses() {
        return this.userClasses;
    }

    public String toString() {
        return "itemPermission: precedence=" + this.getPrecedence() + ", " + "userClasses=" + this.userClasses + ", " + "grantsAndDenials=" + this.getGrantsAndDenials();
    }

    public void printToBuffer(StringBuffer buffer) {
        buffer.append('{');
        buffer.append(' ');
        if (this.getPrecedence() >= 0 && this.getPrecedence() <= 255) {
            buffer.append("precedence");
            buffer.append(' ');
            buffer.append(this.getPrecedence());
            buffer.append(',');
            buffer.append(' ');
        }
        buffer.append("userClasses");
        buffer.append(' ');
        buffer.append('{');
        buffer.append(' ');
        Iterator it = this.userClasses.iterator();
        while (it.hasNext()) {
            UserClass userClass = (UserClass)it.next();
            userClass.printToBuffer(buffer);
            if (!it.hasNext()) continue;
            buffer.append(',');
            buffer.append(' ');
        }
        buffer.append(' ');
        buffer.append('}');
        buffer.append(',');
        buffer.append(' ');
        buffer.append("grantsAndDenials");
        buffer.append(' ');
        buffer.append('{');
        buffer.append(' ');
        it = this.getGrantsAndDenials().iterator();
        while (it.hasNext()) {
            GrantAndDenial grantAndDenial = (GrantAndDenial)it.next();
            grantAndDenial.printToBuffer(buffer);
            if (!it.hasNext()) continue;
            buffer.append(',');
            buffer.append(' ');
        }
        buffer.append(' ');
        buffer.append('}');
        buffer.append(' ');
        buffer.append('}');
    }
}

