/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.management.probes;

import java.io.Serializable;
import java.util.Date;
import org.nuxeo.ecm.core.management.api.ProbeInfo;
import org.nuxeo.ecm.core.management.api.ProbeMBean;
import org.nuxeo.ecm.core.management.probes.ProbeDescriptor;
import org.nuxeo.runtime.management.api.ProbeStatus;

public class ProbeInfoImpl
implements ProbeMBean,
ProbeInfo,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final ProbeDescriptor descriptor;
    protected boolean isEnabled = true;
    protected String shortcutName;
    protected String qualifiedName;
    protected ProbeStatus lastStatus = ProbeStatus.newBlankProbStatus();
    protected long runnedCount = 0L;
    protected Date lastRunnedDate;
    protected long lastDuration = 0L;
    protected long successCount = 0L;
    protected Date lastSucceedDate = new Date(0L);
    protected ProbeStatus lastSuccessStatus = ProbeStatus.newBlankProbStatus();
    protected long failureCount = 0L;
    protected Date lastFailureDate = new Date(0L);
    protected ProbeStatus lastFailureStatus = ProbeStatus.newBlankProbStatus();

    protected ProbeInfoImpl(ProbeDescriptor descriptor) {
        this.descriptor = descriptor;
        this.shortcutName = descriptor.getShortcut();
        this.qualifiedName = descriptor.getQualifiedName();
    }

    @Override
    public long getFailedCount() {
        return this.failureCount;
    }

    @Override
    public long getLastDuration() {
        return this.lastDuration;
    }

    @Override
    public ProbeStatus getLastFailureStatus() {
        return this.lastFailureStatus;
    }

    @Override
    public Date getLastFailedDate() {
        return this.lastFailureDate;
    }

    @Override
    public Date getLastRunnedDate() {
        return this.lastRunnedDate;
    }

    @Override
    public Date getLastSucceedDate() {
        return this.lastSucceedDate;
    }

    @Override
    public long getRunnedCount() {
        return this.runnedCount;
    }

    @Override
    public long getSucceedCount() {
        return this.successCount;
    }

    @Override
    public void disable() {
        this.isEnabled = false;
    }

    @Override
    public void enable() {
        this.isEnabled = true;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public boolean isInError() {
        if (this.lastFailureDate == null) {
            return false;
        }
        if (this.lastSucceedDate != null) {
            return this.lastFailureDate.after(this.lastSucceedDate);
        }
        return true;
    }

    @Override
    public ProbeStatus getStatus() {
        return this.lastStatus;
    }

    @Override
    public String getShortcutName() {
        return this.shortcutName;
    }

    @Override
    public ProbeDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public void setQualifiedName(String qualifiedName) {
        this.qualifiedName = qualifiedName;
    }

    public void setShortcutName(String shortcutName) {
        this.shortcutName = shortcutName;
    }
}

