/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.codec;

import java.util.Map;
import org.nuxeo.lib.stream.codec.AvroBinaryCodec;
import org.nuxeo.lib.stream.codec.AvroConfluentCodec;
import org.nuxeo.lib.stream.codec.AvroJsonCodec;
import org.nuxeo.lib.stream.codec.AvroMessageCodec;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.avro.AvroService;
import org.nuxeo.runtime.codec.CodecFactory;

public class AvroCodecFactory
implements CodecFactory {
    public static final String KEY_SCHEMA_REGISTRY_URLS = "schemaRegistryUrls";
    public static final String DEFAULT_SCHEMA_REGISTRY_URLS = "http://localhost:8081";
    public static final String KEY_ENCODING = "encoding";
    public static final String DEFAULT_ENCODING = "default";
    protected String encoding;
    protected String schemaRegistryUrls;

    @Override
    public void init(Map<String, String> options) {
        this.encoding = options.getOrDefault(KEY_ENCODING, DEFAULT_ENCODING);
        this.schemaRegistryUrls = options.getOrDefault(KEY_SCHEMA_REGISTRY_URLS, DEFAULT_SCHEMA_REGISTRY_URLS);
    }

    @Override
    public <T> Codec<T> newCodec(Class<T> objectClass) {
        switch (this.encoding) {
            case "json": {
                return new AvroJsonCodec(objectClass);
            }
            case "binary": {
                return new AvroBinaryCodec(objectClass);
            }
            case "confluent": {
                return new AvroConfluentCodec(objectClass, this.schemaRegistryUrls);
            }
        }
        return new AvroMessageCodec(objectClass, ((AvroService)Framework.getService(AvroService.class)).getSchemaStore());
    }
}

