/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.automation.scripting.internals;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.automation.scripting.internals.AutomationScriptingServiceImpl;
import org.nuxeo.automation.scripting.internals.ScriptingOperationDescriptor;
import org.nuxeo.automation.scripting.internals.ScriptingOperationTypeImpl;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.runtime.model.SimpleContributionRegistry;

public class AutomationScriptingRegistry
extends SimpleContributionRegistry<ScriptingOperationDescriptor> {
    protected AutomationScriptingServiceImpl scripting;
    protected AutomationService automation;
    protected final Map<String, OperationType> registration = new HashMap<String, OperationType>();

    public String getContributionId(ScriptingOperationDescriptor contrib) {
        return contrib.getId();
    }

    public void contributionRemoved(String id, ScriptingOperationDescriptor origContrib) {
        this.automation.removeOperation(this.registration.remove(id));
    }

    public void contributionUpdated(String id, ScriptingOperationDescriptor contrib, ScriptingOperationDescriptor newOrigContrib) {
        ScriptingOperationTypeImpl type = new ScriptingOperationTypeImpl(this.scripting, this.automation, contrib);
        try {
            this.automation.putOperation((OperationType)type, true);
        }
        catch (OperationException cause) {
            throw new NuxeoException("Cannot update scripting operation " + id, (Throwable)cause);
        }
        this.registration.put(id, type);
    }
}

